/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.weighting.AbstractAdjustedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collection;

public class AvoidEdgesWeighting
extends AbstractAdjustedWeighting {
    protected final IntSet visitedEdges = new GHIntHashSet();
    private double edgePenaltyFactor = 5.0;

    public AvoidEdgesWeighting(Weighting superWeighting) {
        super(superWeighting);
    }

    public AvoidEdgesWeighting setEdgePenaltyFactor(double edgePenaltyFactor) {
        this.edgePenaltyFactor = edgePenaltyFactor;
        return this;
    }

    public void addEdges(Collection<EdgeIteratorState> edges) {
        for (EdgeIteratorState edge : edges) {
            this.visitedEdges.add(edge.getEdge());
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return this.superWeighting.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double weight = this.superWeighting.calcWeight(edgeState, reverse, prevOrNextEdgeId);
        if (this.visitedEdges.contains(edgeState.getEdge())) {
            return weight * this.edgePenaltyFactor;
        }
        return weight;
    }

    @Override
    public String getName() {
        return "avoid_edges";
    }
}

