/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.AbstractAdjustedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.util.EdgeIteratorState;

public class BlockAreaWeighting
extends AbstractAdjustedWeighting {
    private GraphEdgeIdFinder.BlockArea blockArea;

    public BlockAreaWeighting(Weighting superWeighting, GraphEdgeIdFinder.BlockArea blockArea) {
        super(superWeighting);
        this.blockArea = blockArea;
    }

    @Override
    public double getMinWeight(double distance) {
        return this.superWeighting.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        if (this.blockArea.contains(edgeState)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.superWeighting.calcWeight(edgeState, reverse, prevOrNextEdgeId);
    }

    @Override
    public String getName() {
        return "block_area";
    }
}

