/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class GenericWeighting
extends AbstractWeighting {
    public static final String HEIGHT_LIMIT = "height";
    public static final String WEIGHT_LIMIT = "weight";
    public static final String WIDTH_LIMIT = "width";
    protected static final double SPEED_CONV = 3600.0;
    protected final double headingPenalty;
    protected final long headingPenaltyMillis;
    protected final double maxSpeed;
    protected final DataFlagEncoder gEncoder;
    protected final DataFlagEncoder.WeightingConfig weightingConfig;
    protected final int uncertainAccessiblePenalty = 10;
    protected final double height;
    protected final double weight;
    protected final double width;
    private final DecimalEncodedValue carMaxSpeedEnc;
    private final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private DecimalEncodedValue maxWeightEnc;
    private DecimalEncodedValue maxHeightEnc;
    private DecimalEncodedValue maxWidthEnc;

    public GenericWeighting(DataFlagEncoder encoder, PMap hintsMap) {
        super(encoder);
        this.gEncoder = encoder;
        this.headingPenalty = hintsMap.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(this.headingPenalty * 1000.0);
        this.weightingConfig = encoder.createWeightingConfig(hintsMap);
        double maxSpecifiedSpeed = this.weightingConfig.getMaxSpecifiedSpeed();
        if (maxSpecifiedSpeed > encoder.getMaxPossibleSpeed()) {
            throw new IllegalArgumentException("Some specified speed value bigger than maximum possible speed: " + maxSpecifiedSpeed + " > " + encoder.getMaxPossibleSpeed());
        }
        this.maxSpeed = maxSpecifiedSpeed / 3600.0;
        this.height = hintsMap.getDouble(HEIGHT_LIMIT, 0.0);
        this.weight = hintsMap.getDouble(WEIGHT_LIMIT, 0.0);
        this.width = hintsMap.getDouble(WIDTH_LIMIT, 0.0);
        this.roadAccessEnc = encoder.getEnumEncodedValue("road_access", RoadAccess.class);
        this.carMaxSpeedEnc = encoder.getDecimalEncodedValue("max_speed");
        if (encoder.hasEncodedValue("max_weight")) {
            this.maxWeightEnc = encoder.getDecimalEncodedValue("max_weight");
        }
        if (encoder.hasEncodedValue("max_width")) {
            this.maxWidthEnc = encoder.getDecimalEncodedValue("max_width");
        }
        if (encoder.hasEncodedValue("max_height")) {
            this.maxHeightEnc = encoder.getDecimalEncodedValue("max_height");
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed;
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        if (reverse ? !edgeState.getReverse(this.accessEnc) : !edgeState.get(this.accessEnc)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.maxHeightEnc != null && this.overLimit(this.height, edgeState.get(this.maxHeightEnc)) || this.maxWidthEnc != null && this.overLimit(this.width, edgeState.get(this.maxWidthEnc)) || this.maxWeightEnc != null && this.overLimit(this.weight, edgeState.get(this.maxWeightEnc))) {
            return Double.POSITIVE_INFINITY;
        }
        long time = this.calcMillis(edgeState, reverse, prevOrNextEdgeId);
        if (time == Long.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        RoadAccess roadAccessEV = edgeState.get(this.roadAccessEnc);
        if (roadAccessEV == RoadAccess.NO) {
            return Double.POSITIVE_INFINITY;
        }
        if (roadAccessEV != RoadAccess.YES) {
            time *= 10L;
        }
        return time;
    }

    private boolean overLimit(double value, double valueMax) {
        return value > 0.0 && valueMax > 0.0 && value >= valueMax;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double maxspeed;
        double speed = this.weightingConfig.getSpeed(edgeState);
        if (speed == 0.0) {
            return Long.MAX_VALUE;
        }
        double d = maxspeed = reverse ? edgeState.get(this.carMaxSpeedEnc) : edgeState.getReverse(this.carMaxSpeedEnc);
        if (maxspeed > 0.0 && speed > maxspeed) {
            speed = maxspeed;
        }
        long timeInMillis = (long)(edgeState.getDistance() / speed * 3600.0);
        boolean unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            timeInMillis += this.headingPenaltyMillis;
        }
        if (timeInMillis < 0L) {
            throw new IllegalStateException("Some problem with weight calculation: time:" + timeInMillis + ", speed:" + speed);
        }
        return timeInMillis;
    }

    @Override
    public String getName() {
        return "generic";
    }
}

