/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.PathWrapper;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.details.PathDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathSimplification {
    private PointList pointList;
    private Map<String, List<PathDetail>> pathDetails;
    private List<List> listsToSimplify;
    private DouglasPeucker douglasPeucker;

    public PathSimplification(PathWrapper pathWrapper, DouglasPeucker douglasPeucker, boolean enableInstructions) {
        this.pointList = pathWrapper.getPoints();
        this.listsToSimplify = new ArrayList<List>();
        if (enableInstructions) {
            this.listsToSimplify.add((List)pathWrapper.getInstructions());
        }
        this.pathDetails = pathWrapper.getPathDetails();
        for (String name : this.pathDetails.keySet()) {
            List<PathDetail> pathDetailList = this.pathDetails.get(name);
            if (pathDetailList.isEmpty() && this.pointList.size() > 1) {
                throw new IllegalStateException("PathDetails " + name + " must not be empty");
            }
            this.listsToSimplify.add(pathDetailList);
        }
        this.douglasPeucker = douglasPeucker;
    }

    public PointList simplify() {
        int listIndexToShift;
        if (this.pointList.size() <= 2) {
            this.pointList.makeImmutable();
            return this.pointList;
        }
        if (this.listsToSimplify.isEmpty()) {
            this.douglasPeucker.simplify(this.pointList, 0, this.pointList.size() - 1);
            this.pointList.makeImmutable();
            return this.pointList;
        }
        int[] offsets = new int[this.listsToSimplify.size()];
        int[] endIntervals = new int[this.listsToSimplify.size()];
        int[] startIntervals = new int[this.listsToSimplify.size()];
        do {
            int removed;
            boolean simplificationPossible = true;
            int nonConflictingStart = 0;
            int nonConflictingEnd = Integer.MAX_VALUE;
            int listIndexToSimplify = -1;
            listIndexToShift = -1;
            endIntervals = this.calculateEndIntervals(endIntervals, startIntervals, offsets, this.listsToSimplify);
            for (int i = 0; i < this.listsToSimplify.size(); ++i) {
                if (startIntervals[i] >= nonConflictingEnd || endIntervals[i] <= nonConflictingStart) {
                    simplificationPossible = false;
                }
                if (startIntervals[i] > nonConflictingStart) {
                    listIndexToSimplify = -1;
                    nonConflictingStart = startIntervals[i];
                }
                if (endIntervals[i] < nonConflictingEnd) {
                    listIndexToSimplify = -1;
                    nonConflictingEnd = endIntervals[i];
                    listIndexToShift = i;
                }
                if (startIntervals[i] < nonConflictingStart || endIntervals[i] > nonConflictingEnd) continue;
                listIndexToSimplify = i;
            }
            if (listIndexToSimplify >= 0 && simplificationPossible && nonConflictingEnd - nonConflictingStart > 1 && (removed = this.douglasPeucker.simplify(this.pointList, nonConflictingStart, nonConflictingEnd)) > 0) {
                for (int i = 0; i < this.listsToSimplify.size(); ++i) {
                    List pathDetails = this.listsToSimplify.get(i);
                    this.reduceLength(pathDetails, offsets[i], startIntervals[i], endIntervals[i] - removed);
                    if (!(pathDetails.get(0) instanceof PathDetail)) continue;
                    for (int j = offsets[i] + 1; j < pathDetails.size(); ++j) {
                        PathDetail pd = (PathDetail)pathDetails.get(j);
                        this.reduceLength(pathDetails, j, pd.getFirst() - removed, pd.getLast() - removed);
                    }
                }
            }
            if (listIndexToShift < 0) {
                throw new IllegalStateException("toShiftIndex cannot be negative");
            }
            int length = this.getLength(this.listsToSimplify.get(listIndexToShift), offsets[listIndexToShift]);
            int n = listIndexToShift;
            startIntervals[n] = startIntervals[n] + length;
            int n2 = listIndexToShift;
            offsets[n2] = offsets[n2] + 1;
        } while (offsets[listIndexToShift] < this.listsToSimplify.get(listIndexToShift).size());
        for (Map.Entry<String, List<PathDetail>> pdEntry : this.pathDetails.entrySet()) {
            List<PathDetail> list = pdEntry.getValue();
            if (list.isEmpty()) continue;
            PathDetail prevPD = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                if (prevPD.getLast() != list.get(i).getFirst()) {
                    throw new IllegalStateException("PathDetail list " + pdEntry.getKey() + " is inconsistent due to entries " + prevPD + " vs. " + list.get(i));
                }
                prevPD = list.get(i);
            }
        }
        this.pointList.makeImmutable();
        return this.pointList;
    }

    private int getLength(Object o, int index) {
        if (o instanceof InstructionList) {
            return ((InstructionList)o).get(index).getLength();
        }
        if (o instanceof List) {
            return ((PathDetail)((List)o).get(index)).getLength();
        }
        throw new IllegalStateException("We can only handle PathDetails or InstructionList in PathSimplification");
    }

    private void reduceLength(Object o, int index, int startIndex, int newEndIndex) {
        if (o instanceof InstructionList) {
            ((InstructionList)o).get(index).setPoints(this.pointList.shallowCopy(startIndex, newEndIndex, false));
        } else if (o instanceof List) {
            PathDetail pd = (PathDetail)((List)o).get(index);
            pd.setFirst(startIndex);
            pd.setLast(newEndIndex);
        } else {
            throw new IllegalStateException("We can only handle List<PathDetail> or InstructionList");
        }
    }

    private int[] calculateEndIntervals(int[] endIntervals, int[] startIntervals, int[] offset, List<List> toSimplify) {
        for (int i = 0; i < toSimplify.size(); ++i) {
            endIntervals[i] = startIntervals[i] + this.getLength(toSimplify.get(i), offset[i]);
        }
        return endIntervals;
    }
}

