/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.coll.MapEntry;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPathDetailsBuilder
implements PathDetailsBuilder {
    private final String name;
    private boolean isOpen = false;
    private PathDetail currentDetail;
    private List<PathDetail> pathDetails = new ArrayList<PathDetail>();

    public AbstractPathDetailsBuilder(String name) {
        this.name = name;
    }

    protected abstract Object getCurrentValue();

    @Override
    public void startInterval(int firstIndex) {
        Object value = this.getCurrentValue();
        if (this.isOpen) {
            throw new IllegalStateException("PathDetailsBuilder is already in an open state with value: " + this.currentDetail.getValue() + " trying to open a new one with value: " + value);
        }
        this.currentDetail = new PathDetail(value);
        this.currentDetail.setFirst(firstIndex);
        this.isOpen = true;
    }

    @Override
    public void endInterval(int lastIndex) {
        if (this.isOpen) {
            this.currentDetail.setLast(lastIndex);
            this.pathDetails.add(this.currentDetail);
        }
        this.isOpen = false;
    }

    @Override
    public Map.Entry<String, List<PathDetail>> build() {
        return new MapEntry<String, List<PathDetail>>(this.getName(), this.pathDetails);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

