/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner.gizmo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerImplementor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public final class GizmoSolutionClonerFactory {
    private static Map<String, SolutionCloner> solutionClonerMap = new ConcurrentHashMap<String, SolutionCloner>();

    public static String getGeneratedClassName(SolutionDescriptor<?> solutionDescriptor) {
        return solutionDescriptor.getSolutionClass().getName() + "$OptaPlanner$SolutionCloner";
    }

    public static void useSolutionClonerMap(Map<String, SolutionCloner> theSolutionClonerMap) {
        solutionClonerMap = theSolutionClonerMap;
    }

    public static <T> SolutionCloner<T> build(SolutionDescriptor<T> solutionDescriptor) {
        String gizmoMemberAccessorClassName = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        if (solutionClonerMap.containsKey(gizmoMemberAccessorClassName)) {
            return solutionClonerMap.get(gizmoMemberAccessorClassName);
        }
        try {
            Class.forName("io.quarkus.gizmo.ClassCreator", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("When using the domainAccessType (" + (Object)((Object)DomainAccessType.GIZMO) + ") the classpath or modulepath must contain io.quarkus.gizmo:gizmo.\nMaybe add a dependency to io.quarkus.gizmo:gizmo.");
        }
        SolutionCloner<T> cloner = GizmoSolutionClonerImplementor.createClonerFor(solutionDescriptor);
        solutionClonerMap.put(gizmoMemberAccessorClassName, cloner);
        return cloner;
    }

    private GizmoSolutionClonerFactory() {
    }
}

