/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetScoringBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;

public final class BavetScoringBiNode<A, B>
extends BavetAbstractBiNode<A, B>
implements BavetScoringNode {
    private final String constraintPackage;
    private final String constraintName;
    private final Score<?> constraintWeight;
    private final TriFunction<A, B, Consumer<Score<?>>, UndoScoreImpacter> scoreImpacter;
    private final boolean constraintMatchEnabled;
    private final Set<BavetScoringBiTuple<A, B>> tupleSet;

    public BavetScoringBiNode(BavetConstraintSession session, int nodeIndex, String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, Consumer<Score<?>>, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeIndex);
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
        this.constraintMatchEnabled = session.isConstraintMatchEnabled();
        this.tupleSet = this.constraintMatchEnabled ? new HashSet() : null;
    }

    @Override
    public BavetScoringBiTuple<A, B> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetScoringBiTuple<A, B>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetScoringBiTuple tuple = (BavetScoringBiTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.undoScoreImpact();
            if (this.constraintMatchEnabled) {
                tuple.setMatchScore(null);
                boolean removed = this.tupleSet.remove(tuple);
                if (!removed) {
                    throw new IllegalStateException("Impossible state: The node with constraintId (" + this.getConstraintId() + ") could not remove the tuple (" + tuple + ") from the tupleSet.");
                }
            }
        }
        if (tuple.isActive()) {
            boolean added;
            UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(a, b, tuple::setMatchScore);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
            if (this.constraintMatchEnabled && !(added = this.tupleSet.add(tuple))) {
                throw new IllegalStateException("Impossible state: The node with constraintId (" + this.getConstraintId() + ") could not add the tuple (" + tuple + ") to the tupleSet.");
            }
        } else {
            tuple.setUndoScoreImpacter(null);
        }
    }

    @Override
    public <Score_ extends Score<Score_>> ConstraintMatchTotal<Score_> buildConstraintMatchTotal(Score_ zeroScore) {
        DefaultConstraintMatchTotal constraintMatchTotal = new DefaultConstraintMatchTotal(this.constraintPackage, this.constraintName, this.constraintWeight, zeroScore);
        for (BavetScoringBiTuple<A, B> tuple : this.tupleSet) {
            constraintMatchTotal.addConstraintMatch(Arrays.asList(tuple.getFactA(), tuple.getFactB()), tuple.getMatchScore());
        }
        return constraintMatchTotal;
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public String getConstraintId() {
        return ConstraintMatchTotal.composeConstraintId(this.constraintPackage, this.constraintName);
    }

    @Override
    public Score<?> getConstraintWeight() {
        return this.constraintWeight;
    }
}

