/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriTuple;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetFilterTriTuple;

public final class BavetFilterTriNode<A, B, C>
extends BavetAbstractTriNode<A, B, C> {
    private final BavetAbstractTriNode<A, B, C> parentNode;
    private final TriPredicate<A, B, C> predicate;
    private final List<BavetAbstractTriNode<A, B, C>> childNodeList = new ArrayList<BavetAbstractTriNode<A, B, C>>();

    public BavetFilterTriNode(BavetConstraintSession session, int nodeIndex, BavetAbstractTriNode<A, B, C> parentNode, TriPredicate<A, B, C> predicate) {
        super(session, nodeIndex);
        this.parentNode = parentNode;
        this.predicate = predicate;
    }

    @Override
    public void addChildNode(BavetAbstractTriNode<A, B, C> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractTriNode<A, B, C>> getChildNodeList() {
        return this.childNodeList;
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode(this.parentNode), System.identityHashCode(this.predicate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterTriNode) {
            BavetFilterTriNode other = (BavetFilterTriNode)o;
            return this.parentNode == other.parentNode && this.predicate == other.predicate;
        }
        return false;
    }

    @Override
    public BavetFilterTriTuple<A, B, C> createTuple(BavetAbstractTriTuple<A, B, C> parentTuple) {
        return new BavetFilterTriTuple<A, B, C>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetFilterTriTuple tuple = (BavetFilterTriTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        Object c = tuple.getFactC();
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive() && this.predicate.test(a, b, c)) {
            for (BavetAbstractTriNode bavetAbstractTriNode : this.childNodeList) {
                BavetAbstractTriTuple childTuple = bavetAbstractTriNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public String toString() {
        return "Filter() with " + this.childNodeList.size() + " children";
    }
}

