/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.ArrayList;
import java.util.HashSet;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactoryImpl;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final DroolsVariableFactory variableFactory = new DroolsVariableFactoryImpl();
    private final boolean droolsAlphaNetworkCompilationEnabled;

    public DroolsConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, boolean droolsAlphaNetworkCompilationEnabled) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return new DroolsFromUniConstraintStream(this, fromClass);
    }

    @Override
    public ConstraintSessionFactory<Solution_, ?> buildSessionFactory(Constraint[] constraints) {
        ModelImpl model = new ModelImpl();
        AbstractScoreHolder scoreHolder = this.solutionDescriptor.getScoreDefinition().buildScoreHolder(false);
        Class<?> scoreHolderClass = scoreHolder.getClass();
        Package pack = this.solutionDescriptor.getSolutionClass().getPackage();
        Global scoreHolderGlobal = DSL.globalOf(scoreHolderClass, (String)(pack == null ? "" : pack.getName()), (String)"scoreHolder");
        model.addGlobal(scoreHolderGlobal);
        ArrayList droolsConstraintList = new ArrayList(constraints.length);
        HashSet<String> constraintIdSet = new HashSet<String>(constraints.length);
        for (Constraint constraint : constraints) {
            if (constraint.getConstraintFactory() != this) {
                throw new IllegalStateException("The constraint (" + constraint.getConstraintId() + ") must be created from the same constraintFactory.");
            }
            DroolsConstraint droolsConstraint = (DroolsConstraint)constraint;
            boolean added = constraintIdSet.add(droolsConstraint.getConstraintId());
            if (!added) {
                throw new IllegalStateException("There are 2 constraints with the same constraintName (" + droolsConstraint.getConstraintName() + ") in the same constraintPackage (" + droolsConstraint.getConstraintPackage() + ").");
            }
            droolsConstraintList.add(droolsConstraint);
            model.addRule(droolsConstraint.buildRule(scoreHolderGlobal));
        }
        return new DroolsConstraintSessionFactory(this.solutionDescriptor, (Model)model, droolsConstraintList, this.droolsAlphaNetworkCompilationEnabled);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public DroolsVariableFactory getVariableFactory() {
        return this.variableFactory;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

