/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.api.runtime.rule.AccumulateFunction;

abstract class AbstractAccumulateFunction<ResultContainer_, InTuple, OutTuple>
implements AccumulateFunction<AccumulateContext<ResultContainer_>> {
    private final Supplier<ResultContainer_> containerSupplier;
    private final Function<ResultContainer_, OutTuple> finisher;

    protected AbstractAccumulateFunction(Supplier<ResultContainer_> containerSupplier, Function<ResultContainer_, OutTuple> finisher) {
        this.containerSupplier = Objects.requireNonNull(containerSupplier);
        this.finisher = Objects.requireNonNull(finisher);
    }

    public AccumulateContext<ResultContainer_> createContext() {
        return new AccumulateContext<ResultContainer_>(this.containerSupplier);
    }

    public void init(AccumulateContext<ResultContainer_> context) {
        context.reset();
    }

    public void accumulate(AccumulateContext<ResultContainer_> context, Object value) {
        throw new UnsupportedOperationException();
    }

    public Runnable accumulateValue(AccumulateContext<ResultContainer_> context, Object value) {
        return this.accumulate(context.getContainer(), value);
    }

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple var2);

    public void reverse(AccumulateContext<ResultContainer_> context, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean tryReverse(AccumulateContext<ResultContainer_> context, Object value) {
        ((Runnable)value).run();
        return true;
    }

    public OutTuple getResult(AccumulateContext<ResultContainer_> context) {
        return this.finisher.apply(context.getContainer());
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput out) {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in) {
        throw new UnsupportedOperationException();
    }

    static final class AccumulateContext<ResultContainer_>
    implements Serializable {
        private final Supplier<ResultContainer_> containerSupplier;
        private final AtomicReference<ResultContainer_> containerReference = new AtomicReference();

        public AccumulateContext(Supplier<ResultContainer_> containerSupplier) {
            this.containerSupplier = containerSupplier;
        }

        public ResultContainer_ getContainer() {
            return this.containerReference.updateAndGet(container -> container == null ? this.containerSupplier.get() : container);
        }

        public void reset() {
            this.containerReference.set(null);
        }
    }
}

