/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.model.Drools;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.view.ViewItem;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;

abstract class AbstractRuleContext {
    private final List<ViewItem<?>> viewItems;

    protected AbstractRuleContext(ViewItem<?> ... viewItems) {
        this.viewItems = Arrays.stream(viewItems).collect(Collectors.toList());
    }

    protected static void impactScore(Drools drools, AbstractScoreHolder<?> scoreHolder, Object ... justifications) {
        scoreHolder.impactScore((RuleContext)drools, justifications);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, int impact, Object ... justifications) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact, justifications);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, long impact, Object ... justifications) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact, justifications);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, BigDecimal impact, Object ... justifications) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact, justifications);
    }

    protected <Solution_> RuleBuilder<Solution_> assemble(ConsequenceBuilder<Solution_> consequenceBuilder) {
        return (constraint, scoreHolder) -> {
            ArrayList ruleItemBuilderList = new ArrayList(this.viewItems);
            ruleItemBuilderList.add((ViewItem<?>)((RuleItemBuilder)consequenceBuilder.apply(constraint, scoreHolder)));
            return PatternDSL.rule((String)constraint.getConstraintPackage(), (String)constraint.getConstraintName()).build(ruleItemBuilderList.toArray(new RuleItemBuilder[0]));
        };
    }
}

