/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

final class IndirectPatternVariable<A, PatternVar_>
implements PatternVariable<A, PatternVar_, IndirectPatternVariable<A, PatternVar_>> {
    private final Variable<A> primaryVariable;
    private final Supplier<PatternDSL.PatternDef<PatternVar_>> patternSupplier;
    private final Function<PatternVar_, A> mappingFunction;
    private final List<ViewItem<?>> prerequisiteExpressions;
    private final List<ViewItem<?>> dependentExpressions;

    IndirectPatternVariable(IndirectPatternVariable<A, PatternVar_> patternCreator, UnaryOperator<PatternDSL.PatternDef<PatternVar_>> patternMutator) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = () -> (PatternDSL.PatternDef)patternMutator.apply(patternCreator.patternSupplier.get());
        this.mappingFunction = patternCreator.mappingFunction;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = patternCreator.dependentExpressions;
    }

    <OldA> IndirectPatternVariable(IndirectPatternVariable<OldA, PatternVar_> patternCreator, Variable<A> boundVariable, Function<OldA, A> mappingFunction) {
        this.primaryVariable = boundVariable;
        this.patternSupplier = patternCreator.patternSupplier;
        this.mappingFunction = patternCreator.mappingFunction.andThen(mappingFunction);
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = patternCreator.dependentExpressions;
    }

    IndirectPatternVariable(DirectPatternVariable<PatternVar_> patternCreator, Variable<A> boundVariable, Function<PatternVar_, A> mappingFunction) {
        this.primaryVariable = boundVariable;
        this.patternSupplier = patternCreator.getPatternSupplier();
        this.mappingFunction = mappingFunction;
        this.prerequisiteExpressions = patternCreator.getPrerequisiteExpressions();
        this.dependentExpressions = patternCreator.getDependentExpressions();
    }

    IndirectPatternVariable(IndirectPatternVariable<A, PatternVar_> patternCreator, ViewItem<?> dependentExpression) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = patternCreator.patternSupplier;
        this.mappingFunction = patternCreator.mappingFunction;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = Stream.concat(patternCreator.dependentExpressions.stream(), Stream.of(dependentExpression)).collect(Collectors.toList());
    }

    @Override
    public Variable<A> getPrimaryVariable() {
        return this.primaryVariable;
    }

    @Override
    public List<ViewItem<?>> getPrerequisiteExpressions() {
        return this.prerequisiteExpressions;
    }

    @Override
    public List<ViewItem<?>> getDependentExpressions() {
        return this.dependentExpressions;
    }

    private A extract(PatternVar_ patternVar) {
        return this.mappingFunction.apply(patternVar);
    }

    @Override
    public IndirectPatternVariable<A, PatternVar_> filter(Predicate<A> predicate) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.expr("Filter using " + predicate, (Predicate1 & Serializable)a -> predicate.test(this.extract(a))));
    }

    @Override
    public <LeftJoinVar_> IndirectPatternVariable<A, PatternVar_> filter(BiPredicate<LeftJoinVar_, A> predicate, Variable<LeftJoinVar_> leftJoinVariable) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.expr("Filter using " + predicate, leftJoinVariable, (Predicate2 & Serializable)(a, leftJoinVar) -> predicate.test(leftJoinVar, this.extract(a))));
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_> IndirectPatternVariable<A, PatternVar_> filter(TriPredicate<LeftJoinVarA_, LeftJoinVarB_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, (Predicate3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> predicate.test(leftJoinVarA, leftJoinVarB, this.extract(a))));
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> IndirectPatternVariable<A, PatternVar_> filter(QuadPredicate<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Predicate4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> predicate.test(leftJoinVarA, leftJoinVarB, leftJoinVarC, this.extract(a))));
    }

    @Override
    public <LeftJoinVar_> PatternVariable<A, PatternVar_, IndirectPatternVariable<A, PatternVar_>> filterForJoin(Variable<LeftJoinVar_> leftJoinVar, AbstractBiJoiner<LeftJoinVar_, A> joiner, JoinerType joinerType, int mappingIndex) {
        Function leftMapping = joiner.getLeftMapping(mappingIndex);
        Function<A, Object> rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightExtractor.apply(b));
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> {
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, leftMapping::apply);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVar, predicate, index);
        });
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_> PatternVariable<A, PatternVar_, IndirectPatternVariable<A, PatternVar_>> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, AbstractTriJoiner<LeftJoinVarA_, LeftJoinVarB_, A> joiner, JoinerType joinerType, int mappingIndex) {
        BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function<A, Object> rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate3 & Serializable predicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightExtractor.apply(c));
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> {
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, predicate, index);
        });
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> PatternVariable<A, PatternVar_, IndirectPatternVariable<A, PatternVar_>> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, Variable<LeftJoinVarC_> leftJoinVarC, AbstractQuadJoiner<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> joiner, JoinerType joinerType, int mappingIndex) {
        TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function<A, Object> rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate4 & Serializable predicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightExtractor.apply(d));
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> {
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, leftJoinVarC, predicate, index);
        });
    }

    @Override
    public <BoundVar_> IndirectPatternVariable<A, PatternVar_> bind(Variable<BoundVar_> boundVariable, Function<A, BoundVar_> bindingFunction) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.bind(boundVariable, (Function1 & Serializable)a -> bindingFunction.apply(this.extract(a))));
    }

    @Override
    public <BoundVar_, LeftJoinVar_> IndirectPatternVariable<A, PatternVar_> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVar_> leftJoinVariable, BiFunction<A, LeftJoinVar_, BoundVar_> bindingFunction) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.bind(boundVariable, leftJoinVariable, (Function2 & Serializable)(a, leftJoinVar) -> bindingFunction.apply(this.extract(a), leftJoinVar)));
    }

    @Override
    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_> IndirectPatternVariable<A, PatternVar_> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, TriFunction<A, LeftJoinVarA_, LeftJoinVarB_, BoundVar_> bindingFunction) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, (Function3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB)));
    }

    @Override
    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> IndirectPatternVariable<A, PatternVar_> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC, QuadFunction<A, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, BoundVar_> bindingFunction) {
        return new IndirectPatternVariable<A, PatternVar_>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Function4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB, leftJoinVarC)));
    }

    public <NewA> IndirectPatternVariable<NewA, PatternVar_> map(Variable<NewA> boundVariable, Function<A, NewA> mappingFunction) {
        PatternVariable intermediate = this.bind((Variable)boundVariable, mappingFunction);
        return new IndirectPatternVariable<NewA, PatternVar_>(intermediate, boundVariable, mappingFunction);
    }

    @Override
    public IndirectPatternVariable<A, PatternVar_> addDependentExpression(ViewItem<?> expression) {
        return new IndirectPatternVariable<A, PatternVar_>(this, expression);
    }

    @Override
    public List<ViewItem<?>> build() {
        Stream prerequisites = this.prerequisiteExpressions.stream();
        Stream dependents = this.dependentExpressions.stream();
        return Stream.concat(Stream.concat(prerequisites, Stream.of(this.patternSupplier.get())), dependents).collect(Collectors.toList());
    }
}

