/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Optional;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;

public class JavaCompilerFactory {
    public static JavaCompiler loadCompiler(JavaConfiguration configuration) {
        return JavaCompilerFactory.loadCompiler(configuration.getCompiler(), configuration.getJavaLanguageLevel());
    }

    public static JavaCompiler loadCompiler(JavaConfiguration.CompilerType compilerType, String lngLevel) {
        return JavaCompilerFactory.loadCompiler(compilerType, lngLevel, "");
    }

    public static JavaCompiler loadCompiler(JavaConfiguration.CompilerType compilerType, String lngLevel, String sourceFolder) {
        JavaCompiler compiler = JavaCompilerFactory.createCompiler(compilerType).orElseThrow(() -> new RuntimeException("Instance of " + (Object)((Object)compilerType) + " compiler cannot be created!"));
        compiler.setJavaCompilerSettings(JavaCompilerFactory.createSettings(compiler, compilerType, lngLevel));
        compiler.setSourceFolder(sourceFolder);
        return compiler;
    }

    private static JavaCompilerSettings createSettings(JavaCompiler compiler, JavaConfiguration.CompilerType compilerType, String lngLevel) {
        JavaCompilerSettings settings = compiler.createDefaultSettings();
        settings.setTargetVersion(lngLevel);
        if (compilerType == JavaConfiguration.CompilerType.ECLIPSE || lngLevel.startsWith("1.")) {
            settings.setSourceVersion(lngLevel);
        }
        return settings;
    }

    private static Optional<JavaCompiler> createCompiler(JavaConfiguration.CompilerType compilerType) {
        return JavaCompilerFactory.createCompiler(compilerType.getImplClass());
    }

    private static Optional<JavaCompiler> createCompiler(Class compilerClass) {
        try {
            return Optional.of((JavaCompiler)compilerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }
}

