/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class LocationRepositoryImpl
implements LocationRepository {
    private static final Logger logger = LoggerFactory.getLogger(LocationRepositoryImpl.class);
    private final LocationCrudRepository repository;

    @Inject
    LocationRepositoryImpl(LocationCrudRepository repository) {
        this.repository = repository;
    }

    @Override
    public Location createLocation(Coordinates coordinates, String description) {
        LocationEntity locationEntity = new LocationEntity(0L, coordinates.latitude(), coordinates.longitude(), description);
        this.repository.persist(locationEntity);
        Location location = LocationRepositoryImpl.toDomain(locationEntity);
        logger.info("Created location {}.", (Object)location.fullDescription());
        return location;
    }

    @Override
    public List<Location> locations() {
        return this.repository.streamAll().map(LocationRepositoryImpl::toDomain).collect(Collectors.toList());
    }

    @Override
    public Location removeLocation(long id) {
        Optional maybeLocation = this.repository.findByIdOptional(id);
        maybeLocation.ifPresent(locationEntity -> this.repository.deleteById(id));
        LocationEntity locationEntity2 = (LocationEntity)maybeLocation.orElseThrow(() -> new IllegalArgumentException("Location{id=" + id + "} doesn't exist"));
        Location location = LocationRepositoryImpl.toDomain(locationEntity2);
        logger.info("Deleted location {}.", (Object)location.fullDescription());
        return location;
    }

    @Override
    public void removeAll() {
        this.repository.deleteAll();
    }

    @Override
    public Optional<Location> find(long locationId) {
        return this.repository.findByIdOptional(locationId).map(LocationRepositoryImpl::toDomain);
    }

    private static Location toDomain(LocationEntity locationEntity) {
        return new Location(locationEntity.getId(), new Coordinates(locationEntity.getLatitude(), locationEntity.getLongitude()), locationEntity.getDescription());
    }
}

