/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import java.util.Collection;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;

public final class ClientProxies {
    private ClientProxies() {
    }

    public static <T> T getApplicationScopedDelegate(InjectableContext applicationContext, InjectableBean<T> bean) {
        Object result = applicationContext.get((Contextual)bean);
        if (result == null) {
            result = applicationContext.get((Contextual)bean, ClientProxies.newCreationalContext(bean));
        }
        return (T)result;
    }

    public static <T> T getDelegate(InjectableBean<T> bean) {
        Collection<InjectableContext> contexts = Arc.container().getContexts(bean.getScope());
        T result = null;
        InjectableContext selectedContext = null;
        for (InjectableContext context : contexts) {
            if (result != null) {
                if (!context.isActive()) continue;
                throw new IllegalArgumentException("More than one context object for the given scope: " + selectedContext + " " + context);
            }
            result = context.getIfActive(bean, ClientProxies::newCreationalContext);
            if (result == null) continue;
            selectedContext = context;
        }
        if (result == null) {
            throw new ContextNotActiveException();
        }
        return result;
    }

    private static <T> CreationalContextImpl<T> newCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }
}

