/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;

public class UniOnItemTransform<I, O>
extends UniOperator<I, O> {
    private final Function<? super I, ? extends O> mapper;

    public UniOnItemTransform(Uni<I> source, Function<? super I, ? extends O> mapper) {
        super(ParameterValidation.nonNull(source, "source"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onItem(I item) {
                Object outcome;
                try {
                    outcome = UniOnItemTransform.this.mapper.apply(item);
                }
                catch (Throwable e) {
                    subscriber.onFailure(e);
                    return;
                }
                subscriber.onItem(outcome);
            }
        });
    }
}

