/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaweb.vehiclerouting.service.vehicle;

import javax.inject.Inject;

import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;

import io.quarkus.test.junit.QuarkusTest;

@QuarkusTest
class VehicleServiceIntegrationTest {

    @Inject
    VehicleService vehicleService;

    @Test
    void vehicle_service_should_be_transactional() {
        vehicleService.addVehicle(VehicleFactory.testVehicle(1000));
        Vehicle vehicle1 = vehicleService.createVehicle(VehicleFactory.vehicleData("vehicle", 1));
        Vehicle vehicle2 = vehicleService.createVehicle();
        vehicleService.changeCapacity(vehicle2.id(), vehicle2.capacity() + 100);
        vehicleService.createVehicle();
        vehicleService.removeVehicle(vehicle1.id());
        vehicleService.removeAnyVehicle();
        vehicleService.removeAll();
    }
}
