/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CmdArgs
extends PMap {
    public CmdArgs() {
    }

    public CmdArgs(Map<String, String> map) {
        super(map);
    }

    public static CmdArgs read(String[] args) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String arg : args) {
            int index = arg.indexOf("=");
            if (index <= 0) continue;
            String key = arg.substring(0, index);
            if (key.startsWith("-")) {
                key = key.substring(1);
            }
            if (key.startsWith("-")) {
                key = key.substring(1);
            }
            String value = arg.substring(index + 1);
            String old = map.put(Helper.toLowerCase(key), value);
            if (old == null) continue;
            throw new IllegalArgumentException("Pair '" + Helper.toLowerCase(key) + "'='" + value + "' not possible to add to the CmdArgs-object as the key already exists with '" + old + "'");
        }
        return new CmdArgs(map);
    }

    public static CmdArgs readFromSystemProperties() {
        CmdArgs cmdArgs = new CmdArgs();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            if (!k.startsWith("graphhopper.")) continue;
            k = k.substring("graphhopper.".length());
            cmdArgs.put(k, v);
        }
        return cmdArgs;
    }

    @Override
    public CmdArgs put(String key, Object str) {
        super.put(key, str);
        return this;
    }
}

