/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniOnFailureTransform<I, O>
extends UniOperator<I, O> {
    private final Function<? super Throwable, ? extends Throwable> mapper;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailureTransform(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onFailure(Throwable failure) {
                boolean test;
                try {
                    test = UniOnFailureTransform.this.predicate.test(failure);
                }
                catch (RuntimeException e) {
                    subscriber.onFailure(new CompositeException(failure, e));
                    return;
                }
                if (test) {
                    Throwable outcome;
                    try {
                        outcome = (Throwable)UniOnFailureTransform.this.mapper.apply(failure);
                    }
                    catch (Throwable e) {
                        subscriber.onFailure(e);
                        return;
                    }
                    if (outcome == null) {
                        subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
                    } else {
                        subscriber.onFailure(outcome);
                    }
                } else {
                    subscriber.onFailure(failure);
                }
            }
        });
    }
}

