/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class MultiOnTerminationInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final BiConsumer<Throwable, Boolean> callback;

    public MultiOnTerminationInvoke(Multi<? extends T> upstream, BiConsumer<Throwable, Boolean> callback) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.callback = ParameterValidation.nonNull(callback, "callback");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnTerminationInvokeProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnTerminationInvokeProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicBoolean actionInvoke;

        public MultiOnTerminationInvokeProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.actionInvoke = new AtomicBoolean();
        }

        @Override
        public void onFailure(Throwable failure) {
            try {
                this.execute(failure, false);
                super.onFailure(failure);
            }
            catch (Throwable err) {
                super.onFailure(new CompositeException(failure, err));
            }
        }

        @Override
        public void onItem(T item) {
            this.downstream.onItem(item);
        }

        @Override
        public void onCompletion() {
            try {
                this.execute(null, false);
                super.onCompletion();
            }
            catch (Throwable err) {
                super.onFailure(err);
            }
        }

        @Override
        public void cancel() {
            try {
                this.execute(null, true);
            }
            catch (Throwable ignored) {
                Infrastructure.handleDroppedException(ignored);
            }
            super.cancel();
        }

        private void execute(Throwable err, Boolean cancelled) {
            if (this.actionInvoke.compareAndSet(false, true)) {
                MultiOnTerminationInvoke.this.callback.accept(err, cancelled);
            }
        }
    }
}

