/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.routing.util.parsers.OSMMaxHeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMMaxWeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxWidthParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMSurfaceParser;
import com.graphhopper.routing.util.parsers.OSMTollParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class DefaultTagParserFactory
implements TagParserFactory {
    @Override
    public TagParser create(String name, PMap configuration) {
        if (!(name = name.trim()).equals(Helper.toLowerCase((String)name))) {
            throw new IllegalArgumentException("Use lower case for TagParsers: " + name);
        }
        if ("roundabout".equals(name)) {
            return new OSMRoundaboutParser();
        }
        if (name.equals("road_class")) {
            return new OSMRoadClassParser();
        }
        if (name.equals("road_class_link")) {
            return new OSMRoadClassLinkParser();
        }
        if (name.equals("road_environment")) {
            return new OSMRoadEnvironmentParser();
        }
        if (name.equals("road_access")) {
            return new OSMRoadAccessParser();
        }
        if (name.equals("max_speed")) {
            return new OSMMaxSpeedParser();
        }
        if (name.equals("max_weight")) {
            return new OSMMaxWeightParser();
        }
        if (name.equals("max_height")) {
            return new OSMMaxHeightParser();
        }
        if (name.equals("max_width")) {
            return new OSMMaxWidthParser();
        }
        if (name.equals("surface")) {
            return new OSMSurfaceParser();
        }
        if (name.equals("toll")) {
            return new OSMTollParser();
        }
        throw new IllegalArgumentException("entry in encoder list not supported " + name);
    }
}

