/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.GHRequest;
import com.graphhopper.GraphHopper;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWarmUp {
    private static Logger LOGGER = LoggerFactory.getLogger(EngineWarmUp.class);

    public static void warmUp(GraphHopper graphHopper, int iterations) {
        GraphHopperStorage ghStorage = graphHopper.getGraphHopperStorage();
        if (ghStorage == null) {
            throw new IllegalArgumentException("The storage of GraphHopper must not be empty");
        }
        try {
            if (ghStorage.isCHPossible()) {
                EngineWarmUp.warmUpCHSubNetwork(graphHopper, iterations);
            } else {
                EngineWarmUp.warmUpNonCHSubNetwork(graphHopper, iterations);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Problem while sending warm up queries", (Throwable)ex);
        }
    }

    private static void warmUpCHSubNetwork(GraphHopper graphHopper, int iterations) {
        GraphHopperStorage ghStorage = graphHopper.getGraphHopperStorage();
        Random rand = new Random(0L);
        for (int i = 0; i < iterations; ++i) {
            int startNode = rand.nextInt(graphHopper.getMaxVisitedNodes() + 1);
            int endNode = rand.nextInt(graphHopper.getMaxVisitedNodes() + 1);
            double fromLatitude = ghStorage.getNodeAccess().getLatitude(startNode);
            double fromLongitude = ghStorage.getNodeAccess().getLongitude(startNode);
            double toLatitude = ghStorage.getNodeAccess().getLatitude(endNode);
            double toLongitude = ghStorage.getNodeAccess().getLongitude(endNode);
            GHRequest request = new GHRequest(fromLatitude, fromLongitude, toLatitude, toLongitude);
            graphHopper.route(request);
        }
    }

    private static void warmUpNonCHSubNetwork(final GraphHopper graphHopper, int iterations) {
        GraphHopperStorage ghStorage = graphHopper.getGraphHopperStorage();
        Random rand = new Random(0L);
        EdgeExplorer explorer = ghStorage.getBaseGraph().createEdgeExplorer();
        for (int i = 0; i < iterations; ++i) {
            BreadthFirstSearch bfs = new BreadthFirstSearch(){
                int counter = 0;

                @Override
                protected GHBitSet createBitSet() {
                    return new GHTBitSet(graphHopper.getMaxVisitedNodes());
                }

                @Override
                public boolean goFurther(int nodeId) {
                    ++this.counter;
                    return this.counter < graphHopper.getMaxVisitedNodes();
                }
            };
            int startNode = rand.nextInt(ghStorage.getBaseGraph().getNodes() + 1);
            bfs.start(explorer, startNode);
        }
    }
}

