/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class OSMXMLHelper {
    private static final String TYPE_DECODE = "nwr";

    public static ReaderNode createNode(long id, XMLStreamReader parser) throws XMLStreamException {
        ReaderNode node = new ReaderNode(id, Double.parseDouble(parser.getAttributeValue(null, "lat")), Double.parseDouble(parser.getAttributeValue(null, "lon")));
        parser.nextTag();
        OSMXMLHelper.readTags((ReaderElement)node, parser);
        return node;
    }

    public static ReaderWay createWay(long id, XMLStreamReader parser) throws XMLStreamException {
        ReaderWay way = new ReaderWay(id);
        parser.nextTag();
        OSMXMLHelper.readNodes(way, parser);
        OSMXMLHelper.readTags((ReaderElement)way, parser);
        return way;
    }

    private static void readNodes(ReaderWay way, XMLStreamReader parser) throws XMLStreamException {
        int event = parser.getEventType();
        while (event != 8 && parser.getLocalName().equals("nd")) {
            if (event == 1) {
                String ref = parser.getAttributeValue(null, "ref");
                way.getNodes().add(Long.parseLong(ref));
            }
            event = parser.nextTag();
        }
    }

    private static void readTags(ReaderElement re, XMLStreamReader parser) throws XMLStreamException {
        int event = parser.getEventType();
        while (event != 8 && parser.getLocalName().equals("tag")) {
            if (event == 1) {
                String key = parser.getAttributeValue(null, "k");
                String value = parser.getAttributeValue(null, "v");
                if (value != null && value.length() > 0) {
                    re.setTag(key, (Object)value);
                }
            }
            event = parser.nextTag();
        }
    }

    public static ReaderRelation createRelation(long id, XMLStreamReader parser) throws XMLStreamException {
        ReaderRelation rel = new ReaderRelation(id);
        parser.nextTag();
        OSMXMLHelper.readMembers(rel, parser);
        OSMXMLHelper.readTags((ReaderElement)rel, parser);
        return rel;
    }

    private static void readMembers(ReaderRelation rel, XMLStreamReader parser) throws XMLStreamException {
        int event = parser.getEventType();
        while (event != 8 && parser.getLocalName().equalsIgnoreCase("member")) {
            if (event == 1) {
                rel.add(OSMXMLHelper.createMember(parser));
            }
            event = parser.nextTag();
        }
    }

    public static ReaderRelation.Member createMember(XMLStreamReader parser) {
        String typeName = parser.getAttributeValue(null, "type");
        int type = TYPE_DECODE.indexOf(typeName.charAt(0));
        long ref = Long.parseLong(parser.getAttributeValue(null, "ref"));
        String role = parser.getAttributeValue(null, "role");
        return new ReaderRelation.Member(type, ref, role);
    }
}

