/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Default;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public final class HibernateMultiTenantConnectionProvider
extends AbstractMultiTenantConnectionProvider {
    private static final Logger LOG = Logger.getLogger(HibernateMultiTenantConnectionProvider.class);
    private final String persistenceUnitName;
    private final Map<String, ConnectionProvider> providerMap = new ConcurrentHashMap<String, ConnectionProvider>();

    public HibernateMultiTenantConnectionProvider(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    protected ConnectionProvider getAnyConnectionProvider() {
        String tenantId = HibernateMultiTenantConnectionProvider.tenantResolver(this.persistenceUnitName).getDefaultTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Method 'TenantResolver.getDefaultTenantId()' returned a null value. This violates the contract of the interface!");
        }
        return this.selectConnectionProvider(tenantId);
    }

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        LOG.debugv("selectConnectionProvider(persistenceUnitName={0}, tenantIdentifier={1})", (Object)this.persistenceUnitName, (Object)tenantIdentifier);
        ConnectionProvider provider = this.providerMap.get(tenantIdentifier);
        if (provider == null) {
            ConnectionProvider connectionProvider = HibernateMultiTenantConnectionProvider.resolveConnectionProvider(this.persistenceUnitName, tenantIdentifier);
            this.providerMap.put(tenantIdentifier, connectionProvider);
            return connectionProvider;
        }
        return provider;
    }

    private static ConnectionProvider resolveConnectionProvider(String persistenceUnitName, String tenantIdentifier) {
        LOG.debugv("resolveConnectionProvider(persistenceUnitName={0}, tenantIdentifier={1})", (Object)persistenceUnitName, (Object)tenantIdentifier);
        InstanceHandle instance = PersistenceUnitUtil.isDefaultPersistenceUnit(persistenceUnitName) ? Arc.container().instance(TenantConnectionResolver.class, new Annotation[]{Default.Literal.INSTANCE}) : Arc.container().instance(TenantConnectionResolver.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistenceUnitName)});
        if (!instance.isAvailable()) {
            throw new IllegalStateException(String.format("No instance of %1$s was found for persistence unit %2$s. You need to create an implementation for this interface to allow resolving the current tenant connection.", TenantConnectionResolver.class.getSimpleName(), persistenceUnitName));
        }
        TenantConnectionResolver resolver = (TenantConnectionResolver)instance.get();
        ConnectionProvider cp = resolver.resolve(tenantIdentifier);
        if (cp == null) {
            throw new IllegalStateException("Method 'TenantConnectionResolver.resolve(String)' returned a null value. This violates the contract of the interface!");
        }
        return cp;
    }

    private static TenantResolver tenantResolver(String persistenceUnitName) {
        InstanceHandle resolverInstance = PersistenceUnitUtil.isDefaultPersistenceUnit(persistenceUnitName) ? Arc.container().instance(TenantResolver.class, new Annotation[]{Default.Literal.INSTANCE}) : Arc.container().instance(TenantResolver.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistenceUnitName)});
        if (!resolverInstance.isAvailable()) {
            throw new IllegalStateException(String.format("No instance of %1$s was found for persistence unit %2$s. You need to create an implementation for this interface to allow resolving the current tenant identifier.", TenantResolver.class.getSimpleName(), persistenceUnitName));
        }
        return (TenantResolver)resolverInstance.get();
    }
}

