/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.quad.DefaultQuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.tri.DefaultTriConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;

public final class ConstraintCollectors {
    public static <A> UniConstraintCollector<A, ?, Integer> count() {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countLong() {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countBi() {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countLongBi() {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> countTri() {
        return new DefaultTriConstraintCollector<Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> countLongTri() {
        return new DefaultTriConstraintCollector<Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> countQuad() {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c, d) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> countLongQuad() {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c, d) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct() {
        return ConstraintCollectors.countDistinct(Function.identity());
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct(Function<A, ?> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countDistinctLong(Function<A, ?> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countDistinct(BiFunction<A, B, ?> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply(a, b);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countDistinctLong(BiFunction<A, B, ?> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply(a, b);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> countDistinct(TriFunction<A, B, C, ?> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> countDistinctLong(TriFunction<A, B, C, ?> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> countDistinct(QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> countDistinctLong(QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    private static Runnable innerCountDistinct(CountDistinctResultContainer resultContainer, Object value) {
        int[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new int[1]);
        if ((long)objectCount[0] == 0L) {
            ++resultContainer.count;
        }
        objectCount[0] = objectCount[0] + 1;
        return () -> {
            int[] objectCount2 = resultContainer.objectCountMap.get(value);
            if (objectCount2 == null) {
                throw new IllegalStateException("Impossible state: the value (" + value + ") is removed more times than it was added.");
            }
            objectCount2[0] = objectCount2[0] - 1;
            if ((long)objectCount2[0] == 0L) {
                resultContainer.objectCountMap.remove(value);
                --resultContainer.count;
            }
        };
    }

    private static Runnable innerCountDistinctLong(CountDistinctLongResultContainer resultContainer, Object value) {
        long[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new long[1]);
        if (objectCount[0] == 0L) {
            ++resultContainer.count;
        }
        objectCount[0] = objectCount[0] + 1L;
        return () -> {
            long[] objectCount2 = resultContainer.objectCountMap.get(value);
            if (objectCount2 == null) {
                throw new IllegalStateException("Impossible state: the value (" + value + ") is removed more times than it was added.");
            }
            objectCount2[0] = objectCount2[0] - 1L;
            if (objectCount2[0] == 0L) {
                resultContainer.objectCountMap.remove(value);
                --resultContainer.count;
            }
        };
    }

    public static <A> UniConstraintCollector<A, ?, Integer> sum(ToIntFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            int value = groupValueMapping.applyAsInt((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> sumLong(ToLongFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            long value = groupValueMapping.applyAsLong((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, Result> UniConstraintCollector<A, ?, Result> sum(Function<? super A, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultUniConstraintCollector<Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a) -> {
            Object value = groupValueMapping.apply((Object)a);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    private static <Result> Result[] createContainer(Result initialValue) {
        Object[] container = (Object[])Array.newInstance(initialValue.getClass(), 1);
        container[0] = initialValue;
        return container;
    }

    public static <A> UniConstraintCollector<A, ?, BigDecimal> sumBigDecimal(Function<? super A, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A> UniConstraintCollector<A, ?, BigInteger> sumBigInteger(Function<? super A, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A> UniConstraintCollector<A, ?, Duration> sumDuration(Function<? super A, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A> UniConstraintCollector<A, ?, Period> sumPeriod(Function<? super A, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> sum(ToIntBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            int value = groupValueMapping.applyAsInt((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> sumLong(ToLongBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            long value = groupValueMapping.applyAsLong((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, Result> BiConstraintCollector<A, B, ?, Result> sum(BiFunction<? super A, ? super B, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultBiConstraintCollector<Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> sumBigDecimal(BiFunction<? super A, ? super B, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigInteger> sumBigInteger(BiFunction<? super A, ? super B, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Duration> sumDuration(BiFunction<? super A, ? super B, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Period> sumPeriod(BiFunction<? super A, ? super B, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> sum(ToIntTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c) -> {
            int value = groupValueMapping.applyAsInt(a, b, c);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> sumLong(ToLongTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c) -> {
            long value = groupValueMapping.applyAsLong(a, b, c);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, Result> TriConstraintCollector<A, B, C, ?, Result> sum(TriFunction<? super A, ? super B, ? super C, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultTriConstraintCollector<Object, Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> sumBigDecimal(TriFunction<? super A, ? super B, ? super C, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigInteger> sumBigInteger(TriFunction<? super A, ? super B, ? super C, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Duration> sumDuration(TriFunction<? super A, ? super B, ? super C, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Period> sumPeriod(TriFunction<? super A, ? super B, ? super C, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> sum(ToIntQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c, d) -> {
            int value = groupValueMapping.applyAsInt(a, b, c, d);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> sumLong(ToLongQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c, d) -> {
            long value = groupValueMapping.applyAsLong(a, b, c, d);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D, Result> QuadConstraintCollector<A, B, C, D, ?, Result> sum(QuadFunction<? super A, ? super B, ? super C, ? super D, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigDecimal> sumBigDecimal(QuadFunction<? super A, ? super B, ? super C, ? super D, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigInteger> sumBigInteger(QuadFunction<? super A, ? super B, ? super C, ? super D, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Duration> sumDuration(QuadFunction<? super A, ? super B, ? super C, ? super D, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Period> sumPeriod(QuadFunction<? super A, ? super B, ? super C, ? super D, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> min() {
        return ConstraintCollectors.min(Function.identity(), Comparable::compareTo);
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, Mapped> min(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparable::compareTo);
    }

    public static <A> UniConstraintCollector<A, ?, A> min(Comparator<A> comparator) {
        return ConstraintCollectors.min(Function.identity(), comparator);
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> min(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, Mapped> min(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> min(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, Mapped> min(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> min(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Mapped> min(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> min(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> max() {
        return ConstraintCollectors.max(Function.identity(), Comparable::compareTo);
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, Mapped> max(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparable::compareTo);
    }

    public static <A> UniConstraintCollector<A, ?, A> max(Comparator<A> comparator) {
        return ConstraintCollectors.max(Function.identity(), comparator);
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> max(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, Mapped> UniConstraintCollector<A, SortedMap<Mapped, Long>, Mapped> minOrMax(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultUniConstraintCollector<Object, SortedMap, Object>(() -> new TreeMap(comparator), (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            return ConstraintCollectors.minOrMaxAccumulator(resultContainer, mapped);
        }, resultContainer -> ConstraintCollectors.minOrMaxFinisher(resultContainer, min));
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, Mapped> max(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> max(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, Mapped> BiConstraintCollector<A, B, SortedMap<Mapped, Long>, Mapped> minOrMax(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultBiConstraintCollector<Object, Object, SortedMap, Object>(() -> new TreeMap(comparator), (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            return ConstraintCollectors.minOrMaxAccumulator(resultContainer, mapped);
        }, resultContainer -> ConstraintCollectors.minOrMaxFinisher(resultContainer, min));
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, Mapped> max(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> max(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, C, Mapped> TriConstraintCollector<A, B, C, SortedMap<Mapped, Long>, Mapped> minOrMax(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultTriConstraintCollector<Object, Object, Object, SortedMap, Object>(() -> new TreeMap(comparator), (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.minOrMaxAccumulator(resultContainer, mapped);
        }, resultContainer -> ConstraintCollectors.minOrMaxFinisher(resultContainer, min));
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Mapped> max(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparable::compareTo);
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> max(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, SortedMap<Mapped, Long>, Mapped> minOrMax(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, SortedMap, Object>(() -> new TreeMap(comparator), (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.minOrMaxAccumulator(resultContainer, mapped);
        }, resultContainer -> ConstraintCollectors.minOrMaxFinisher(resultContainer, min));
    }

    private static <Mapped> Runnable minOrMaxAccumulator(SortedMap<Mapped, Long> resultContainer, Mapped mapped) {
        resultContainer.compute(mapped, (key, value) -> value == null ? 1L : value + 1L);
        return () -> resultContainer.compute(mapped, (key, value) -> value == 1L ? null : Long.valueOf(value - 1L));
    }

    private static <Mapped> Mapped minOrMaxFinisher(SortedMap<Mapped, Long> resultContainer, boolean min) {
        Function<SortedMap, Object> keySupplier = min ? SortedMap::firstKey : SortedMap::lastKey;
        return (Mapped)(resultContainer.isEmpty() ? null : keySupplier.apply(resultContainer));
    }

    public static <A, Result extends Collection<A>> UniConstraintCollector<A, ?, Result> toCollection(IntFunction<Result> collectionFunction) {
        return ConstraintCollectors.toCollection(Function.identity(), collectionFunction);
    }

    public static <A> UniConstraintCollector<A, ?, Set<A>> toSet() {
        return ConstraintCollectors.toSet(Function.identity());
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, SortedSet<A>> toSortedSet() {
        return ConstraintCollectors.toCollection(Function.identity(), (int i) -> new TreeSet());
    }

    public static <A> UniConstraintCollector<A, ?, List<A>> toList() {
        return ConstraintCollectors.toList(Function.identity());
    }

    public static <A, Mapped, Result extends Collection<Mapped>> UniConstraintCollector<A, ?, Result> toCollection(Function<A, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultUniConstraintCollector<Object, List, Collection>(ArrayList::new, (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    private static <Mapped, Container extends List<Mapped>, Result extends Collection<Mapped>> Result toCollectionFinisher(IntFunction<Result> collectionFunction, Container resultContainer) {
        int size = resultContainer.size();
        Collection collection = (Collection)collectionFunction.apply(size);
        if (size > 0) {
            collection.addAll(resultContainer);
        }
        return (Result)collection;
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Set<Mapped>> toSet(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, LinkedHashSet::new);
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, SortedSet<Mapped>> toSortedSet(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, (int i) -> new TreeSet());
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, List<Mapped>> toList(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, ArrayList::new);
    }

    public static <A, B, Mapped, Result extends Collection<Mapped>> BiConstraintCollector<A, B, ?, Result> toCollection(BiFunction<A, B, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultBiConstraintCollector<Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Set<Mapped>> toSet(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, LinkedHashSet::new);
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, SortedSet<Mapped>> toSortedSet(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, (int i) -> new TreeSet());
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, List<Mapped>> toList(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, ArrayList::new);
    }

    public static <A, B, C, Mapped, Result extends Collection<Mapped>> TriConstraintCollector<A, B, C, ?, Result> toCollection(TriFunction<A, B, C, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Set<Mapped>> toSet(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, LinkedHashSet::new);
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, SortedSet<Mapped>> toSortedSet(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, (int i) -> new TreeSet());
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, List<Mapped>> toList(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, ArrayList::new);
    }

    public static <A, B, C, D, Mapped, Result extends Collection<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Result> toCollection(QuadFunction<A, B, C, D, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Set<Mapped>> toSet(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, LinkedHashSet::new);
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, SortedSet<Mapped>> toSortedSet(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, (int i) -> new TreeSet());
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, List<Mapped>> toList(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.toCollection(groupValueMapping, ArrayList::new);
    }

    public static <A, Key, Value> UniConstraintCollector<A, ?, Map<Key, Set<Value>>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key, Value, ValueSet extends Set<Value>> UniConstraintCollector<A, ?, Map<Key, ValueSet>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultUniConstraintCollector<Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction))));
    }

    private static <A, Key, Value> Runnable toMapAccumulator(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, ToMapResultContainer<Key, Value> resultContainer, A a) {
        Key key = keyMapper.apply(a);
        Value value = valueMapper.apply(a);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    private static <Key, Value> Runnable toMapInnerAccumulator(Key key, Value value, ToMapResultContainer<Key, Value> resultContainer) {
        resultContainer.add(key, value);
        return () -> resultContainer.remove(key, value);
    }

    private static <Value, ValueSet extends Set<Value>> ValueSet toValueSet(Set<Value> in, IntFunction<ValueSet> valueSetFunction) {
        Set result = (Set)valueSetFunction.apply(in.size());
        result.addAll(in);
        return (ValueSet)result;
    }

    public static <A, Key, Value> UniConstraintCollector<A, ?, Map<Key, Value>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultUniConstraintCollector<Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValue((Set)e.value, mergeFunction))));
    }

    private static <Value> Value toValue(Set<Value> in, BinaryOperator<Value> mergeFunction) {
        return (Value)in.stream().reduce(mergeFunction).orElseThrow(() -> new IllegalStateException("Programming error: Should have had at least one value."));
    }

    public static <A, Key extends Comparable<Key>, Value> UniConstraintCollector<A, ?, SortedMap<Key, Set<Value>>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> UniConstraintCollector<A, ?, SortedMap<Key, ValueSet>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultUniConstraintCollector<Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    private static <Value> Value throwOnKeyConflict(Value firstValue, Value secondValue) {
        throw new IllegalStateException("Programming error, key conflict: (" + firstValue + "), (" + secondValue + ").");
    }

    public static <A, Key extends Comparable<Key>, Value> UniConstraintCollector<A, ?, SortedMap<Key, Value>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultUniConstraintCollector<Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValue((Set)e.value, mergeFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, Key, Value> BiConstraintCollector<A, B, ?, Map<Key, Set<Value>>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key, Value, ValueSet extends Set<Value>> BiConstraintCollector<A, B, ?, Map<Key, ValueSet>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction))));
    }

    private static <A, B, Key, Value> Runnable toMapAccumulator(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, ToMapResultContainer<Key, Value> resultContainer, A a, B b) {
        Key key = keyMapper.apply(a, b);
        Value value = valueMapper.apply(a, b);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, Key, Value> BiConstraintCollector<A, B, ?, Map<Key, Value>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValue((Set)e.value, mergeFunction))));
    }

    public static <A, B, Key extends Comparable<Key>, Value> BiConstraintCollector<A, B, ?, SortedMap<Key, Set<Value>>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> BiConstraintCollector<A, B, ?, SortedMap<Key, ValueSet>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, Key extends Comparable<Key>, Value> BiConstraintCollector<A, B, ?, SortedMap<Key, Value>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValue((Set)e.value, mergeFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, C, Key, Value> TriConstraintCollector<A, B, C, ?, Map<Key, Set<Value>>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key, Value, ValueSet extends Set<Value>> TriConstraintCollector<A, B, C, ?, Map<Key, ValueSet>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction))));
    }

    private static <A, B, C, Key, Value> Runnable toMapAccumulator(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, ToMapResultContainer<Key, Value> resultContainer, A a, B b, C c) {
        Key key = keyMapper.apply(a, b, c);
        Value value = valueMapper.apply(a, b, c);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, C, Key, Value> TriConstraintCollector<A, B, C, ?, Map<Key, Value>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValue((Set)e.value, mergeFunction))));
    }

    public static <A, B, C, Key extends Comparable<Key>, Value> TriConstraintCollector<A, B, C, ?, SortedMap<Key, Set<Value>>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> TriConstraintCollector<A, B, C, ?, SortedMap<Key, ValueSet>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, C, Key extends Comparable<Key>, Value> TriConstraintCollector<A, B, C, ?, SortedMap<Key, Value>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValue((Set)e.value, mergeFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, C, D, Key, Value> QuadConstraintCollector<A, B, C, D, ?, Map<Key, Set<Value>>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key, Value, ValueSet extends Set<Value>> QuadConstraintCollector<A, B, C, D, ?, Map<Key, ValueSet>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction))));
    }

    private static <A, B, C, D, Key, Value> Runnable toMapAccumulator(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, ToMapResultContainer<Key, Value> resultContainer, A a, B b, C c, D d) {
        Key key = keyMapper.apply(a, b, c, d);
        Value value = valueMapper.apply(a, b, c, d);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, C, D, Key, Value> QuadConstraintCollector<A, B, C, D, ?, Map<Key, Value>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMapResultContainer, Map>(() -> new ToMapResultContainer(), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap((? super T e) -> e.key, (? super T e) -> ConstraintCollectors.toValue((Set)e.value, mergeFunction))));
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Set<Value>>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, ValueSet>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValueSet((Set)e.value, valueSetFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Value>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMapResultContainer, SortedMap>(() -> new ToMapResultContainer(), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), resultContainer -> resultContainer.entries().filter(e -> !((Set)e.value).isEmpty()).collect(Collectors.toMap(e -> (Comparable)e.key, e -> ConstraintCollectors.toValue((Set)e.value, mergeFunction), ConstraintCollectors::throwOnKeyConflict, TreeMap::new)));
    }

    private ConstraintCollectors() {
    }

    private static final class ToMapResultContainer<Key, Value> {
        private final Map<Key, ToMapPerKeyCounter<Value>> valueCounts = new HashMap<Key, ToMapPerKeyCounter<Value>>(0);

        private ToMapResultContainer() {
        }

        public void add(Key key, Value value) {
            ToMapPerKeyCounter counter = this.valueCounts.computeIfAbsent(key, k -> new ToMapPerKeyCounter());
            counter.add(value);
        }

        public void remove(Key key, Value value) {
            ToMapPerKeyCounter<Value> counter = this.valueCounts.get(key);
            counter.remove(value);
            if (counter.isEmpty()) {
                this.valueCounts.remove(key);
            }
        }

        public Stream<Tuple<Key, Set<Value>>> entries() {
            return this.valueCounts.entrySet().stream().map(e -> new Tuple(e.getKey(), ((ToMapPerKeyCounter)e.getValue()).getValues()));
        }
    }

    private static final class Tuple<Key, Value> {
        public final Key key;
        public final Value value;

        public Tuple(Key key, Value value) {
            this.key = key;
            this.value = value;
        }
    }

    private static final class ToMapPerKeyCounter<Value> {
        private final Map<Value, Long> counts = new LinkedHashMap<Value, Long>(0);

        private ToMapPerKeyCounter() {
        }

        public long add(Value value) {
            return this.counts.compute(value, (k, currentCount) -> {
                if (currentCount == null) {
                    return 1L;
                }
                return currentCount + 1L;
            });
        }

        public long remove(Value value) {
            Long newCount = this.counts.compute(value, (k, currentCount) -> {
                if (currentCount > 1L) {
                    return currentCount - 1L;
                }
                return null;
            });
            return newCount == null ? 0L : newCount;
        }

        public Set<Value> getValues() {
            return this.counts.keySet();
        }

        public boolean isEmpty() {
            return this.counts.isEmpty();
        }
    }

    private static class CountDistinctLongResultContainer {
        long count = 0L;
        Map<Object, long[]> objectCountMap = new HashMap<Object, long[]>();

        private CountDistinctLongResultContainer() {
        }
    }

    private static class CountDistinctResultContainer {
        int count = 0;
        Map<Object, int[]> objectCountMap = new HashMap<Object, int[]>();

        private CountDistinctResultContainer() {
        }
    }
}

