/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.partitionedsearch.queue.PartitionChangedEvent;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionChangeMove;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionQueue<Solution_>
implements Iterable<PartitionChangeMove<Solution_>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionQueue.class);
    private BlockingQueue<PartitionChangedEvent<Solution_>> queue;
    private Map<Integer, PartitionChangedEvent<Solution_>> moveEventMap;
    private final Map<Integer, AtomicLong> nextEventIndexMap;
    private int openPartCount;
    private long partsCalculationCount;
    private final Map<Integer, Long> processedEventIndexMap;

    public PartitionQueue(int partCount) {
        int i;
        this.queue = new ArrayBlockingQueue<PartitionChangedEvent<Solution_>>(partCount * 100);
        this.moveEventMap = new ConcurrentHashMap<Integer, PartitionChangedEvent<Solution_>>(partCount);
        HashMap<Integer, AtomicLong> nextEventIndexMap = new HashMap<Integer, AtomicLong>(partCount);
        for (i = 0; i < partCount; ++i) {
            nextEventIndexMap.put(i, new AtomicLong(0L));
        }
        this.nextEventIndexMap = Collections.unmodifiableMap(nextEventIndexMap);
        this.openPartCount = partCount;
        this.partsCalculationCount = 0L;
        this.processedEventIndexMap = new HashMap<Integer, Long>(partCount);
        for (i = 0; i < partCount; ++i) {
            this.processedEventIndexMap.put(i, -1L);
        }
    }

    public void addMove(int partIndex, PartitionChangeMove<Solution_> move) {
        long eventIndex = this.nextEventIndexMap.get(partIndex).getAndIncrement();
        PartitionChangedEvent<Solution_> event = new PartitionChangedEvent<Solution_>(partIndex, eventIndex, move);
        this.moveEventMap.put(event.getPartIndex(), event);
        this.queue.add(event);
    }

    public void addFinish(int partIndex, long partCalculationCount) {
        long eventIndex = this.nextEventIndexMap.get(partIndex).getAndIncrement();
        PartitionChangedEvent event = new PartitionChangedEvent(partIndex, eventIndex, partCalculationCount);
        this.queue.add(event);
    }

    public void addExceptionThrown(int partIndex, Throwable throwable) {
        long eventIndex = this.nextEventIndexMap.get(partIndex).getAndIncrement();
        PartitionChangedEvent event = new PartitionChangedEvent(partIndex, eventIndex, throwable);
        this.queue.add(event);
    }

    @Override
    public Iterator<PartitionChangeMove<Solution_>> iterator() {
        return new PartitionQueueIterator();
    }

    public long getPartsCalculationCount() {
        return this.partsCalculationCount;
    }

    private class PartitionQueueIterator
    extends UpcomingSelectionIterator<PartitionChangeMove<Solution_>> {
        private PartitionQueueIterator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected PartitionChangeMove<Solution_> createUpcomingSelection() {
            PartitionChangedEvent triggerEvent;
            block7: while (true) {
                try {
                    triggerEvent = (PartitionChangedEvent)PartitionQueue.this.queue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Solver thread was interrupted in Partitioned Search.", e);
                }
                switch (triggerEvent.getType()) {
                    case MOVE: {
                        int partIndex = triggerEvent.getPartIndex();
                        long processedEventIndex = (Long)PartitionQueue.this.processedEventIndexMap.get(partIndex);
                        if (triggerEvent.getEventIndex() <= processedEventIndex) {
                            LOGGER.trace("    Skipped event of partIndex ({}).", (Object)partIndex);
                            continue block7;
                        }
                        PartitionChangedEvent latestMoveEvent = (PartitionChangedEvent)PartitionQueue.this.moveEventMap.get(partIndex);
                        PartitionQueue.this.processedEventIndexMap.put(partIndex, latestMoveEvent.getEventIndex());
                        return latestMoveEvent.getMove();
                    }
                    case FINISHED: {
                        PartitionQueue.this.openPartCount--;
                        PartitionQueue.this.partsCalculationCount += triggerEvent.getPartCalculationCount();
                        if (PartitionQueue.this.openPartCount <= 0) return (PartitionChangeMove)this.noUpcomingSelection();
                        continue block7;
                    }
                    case EXCEPTION_THROWN: {
                        throw new IllegalStateException("The partition child thread with partIndex (" + triggerEvent.getPartIndex() + ") has thrown an exception. Relayed here in the parent thread.", triggerEvent.getThrowable());
                    }
                }
                break;
            }
            throw new IllegalStateException("The partitionChangedEventType (" + (Object)((Object)triggerEvent.getType()) + ") is not implemented.");
        }
    }
}

