/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactoryImpl;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final DroolsVariableFactory variableFactory = new DroolsVariableFactoryImpl();
    private final boolean droolsAlphaNetworkCompilationEnabled;

    public DroolsConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, boolean droolsAlphaNetworkCompilationEnabled) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return new DroolsFromUniConstraintStream(this, fromClass);
    }

    public DroolsConstraintSessionFactory<Solution_, ?> buildSessionFactory(Constraint[] constraints) {
        Map<String, List<Constraint>> constraintsPerIdMap = Arrays.stream(constraints).collect(Collectors.groupingBy(Constraint::getConstraintId));
        constraintsPerIdMap.forEach((constraintId, constraintList) -> {
            if (constraintList.size() > 1) {
                throw new IllegalStateException("There are multiple constraints with the same name in a package (" + constraintId + ").");
            }
        });
        return new DroolsConstraintSessionFactory(this.solutionDescriptor, this, this.droolsAlphaNetworkCompilationEnabled, constraints);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public DroolsVariableFactory getVariableFactory() {
        return this.variableFactory;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

