/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Stream;
import org.drools.model.BetaIndex2;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.BiRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DetachedPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.IndirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.QuadRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.UniRuleContext;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.FilteringTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class BiLeftHandSide<A, B>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariableA;
    private final PatternVariable<B, ?, ?> patternVariableB;
    private final BiRuleContext<A, B> ruleContext;

    protected BiLeftHandSide(PatternVariable<A, ?, ?> left, PatternVariable<B, ?, ?> right, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = left;
        this.patternVariableB = right;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    protected BiLeftHandSide(BiRuleContext<A, B> ruleContext, PatternVariable<A, ?, ?> left, PatternVariable<B, ?, ?> right, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = left;
        this.patternVariableB = right;
        this.ruleContext = Objects.requireNonNull(ruleContext);
    }

    protected BiLeftHandSide(BiLeftHandSide<A, B> leftHandSide, PatternVariable<B, ?, ?> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = leftHandSide.patternVariableA;
        this.patternVariableB = patternVariable;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    protected BiLeftHandSide(BiLeftHandSide<A, B> leftHandSide, PatternVariable<A, ?, ?> left, PatternVariable<B, ?, ?> right) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = left;
        this.patternVariableB = right;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    private BiRuleContext<A, B> buildDefaultRuleContext() {
        ViewItem[] viewItems = (ViewItem[])Stream.of(this.patternVariableA, this.patternVariableB).flatMap(variable -> variable.build().stream()).toArray(ViewItem[]::new);
        return new BiRuleContext<A, B>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), viewItems);
    }

    protected PatternVariable<A, ?, ?> getPatternVariableA() {
        return this.patternVariableA;
    }

    protected PatternVariable<B, ?, ?> getPatternVariableB() {
        return this.patternVariableB;
    }

    public BiLeftHandSide<A, B> andFilter(BiPredicate<A, B> predicate) {
        return new BiLeftHandSide<A, B>(this, this.patternVariableA, this.patternVariableB.filter(predicate, this.patternVariableA.getPrimaryVariable()));
    }

    private <C> BiLeftHandSide<A, B> applyJoiners(Class<C> otherFactType, AbstractTriJoiner<A, B, C> joiner, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        Variable<C> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate3 & Serializable joinPredicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightMapping.apply(c));
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)BiLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (Predicate3)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <C> BiLeftHandSide<A, B> applyFilters(PatternDSL.PatternDef<C> existencePattern, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (Predicate3 & Serializable)(c, a, b) -> predicate.test(a, b, c));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new BiLeftHandSide<A, B>(this, this.patternVariableB.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <C> BiLeftHandSide<A, B> existsOrNot(Class<C> cClass, TriJoiner<A, B, C>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractTriJoiner finalJoiner = null;
        TriPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractTriJoiner joiner = (AbstractTriJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneTriJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringTriJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractTriJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(cClass, finalJoiner, finalFilter, shouldExist);
    }

    public <C> BiLeftHandSide<A, B> andExists(Class<C> cClass, TriJoiner<A, B, C>[] joiners) {
        return this.existsOrNot(cClass, joiners, true);
    }

    public <C> BiLeftHandSide<A, B> andNotExists(Class<C> cClass, TriJoiner<A, B, C>[] joiners) {
        return this.existsOrNot(cClass, joiners, false);
    }

    public <C> TriLeftHandSide<A, B, C> andJoin(UniLeftHandSide<C> right, TriJoiner<A, B, C> joiner) {
        AbstractTriJoiner castJoiner = (AbstractTriJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable<C, ?, ?> newRight = right.getPatternVariableA();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterForJoin(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new TriLeftHandSide<A, B, C>(this.patternVariableA, this.patternVariableB, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collector) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collector, accumulateSource, accumulateOutput));
        UniRuleContext simpleRuleContext = new UniRuleContext(accumulateOutput, outerAccumulatePattern);
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB));
        BiRuleContext simpleRuleContext = new BiRuleContext(accumulateOutputA, accumulateOutputB, outerAccumulatePattern);
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DirectPatternVariable(accumulateOutputB, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC));
        TriRuleContext simpleRuleContext = new TriRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, outerAccumulatePattern);
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        QuadRuleContext simpleRuleContext = new QuadRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, accumulateOutputD, outerAccumulatePattern);
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(BiConstraintCollector<A, B, ?, Out> collector, Variable<BiTuple<A, B>> in, Variable<Out> out) {
        return DSL.accFunction(() -> new BiAccumulateFunction(collector), in).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(BiFunction<A, B, NewA> keyMapping) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMapping::apply);
        UniRuleContext simpleRuleContext = new UniRuleContext(groupKey, groupByPattern);
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(groupKey, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutput));
        BiRuleContext simpleRuleContext = new BiRuleContext(groupKey, accumulateOutput, groupByPattern);
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DirectPatternVariable(accumulateOutput, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC));
        TriRuleContext simpleRuleContext = new TriRuleContext(groupKey, accumulateOutputB, accumulateOutputC, groupByPattern);
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        QuadRuleContext simpleRuleContext = new QuadRuleContext(groupKey, accumulateOutputB, accumulateOutputC, accumulateOutputD, groupByPattern);
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    private <NewA, NewB> Function2<A, B, BiTuple<NewA, NewB>> createCompositeBiGroupKey(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB) {
        return (Function2 & Serializable)(a, b) -> new BiTuple(keyMappingA.apply(a, b), keyMappingB.apply(a, b));
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB) {
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        IndirectPatternVariable<Object, BiTuple> bPatternVar = new IndirectPatternVariable<Object, BiTuple>(tuplePatternVar, newB, tuple -> tuple.b);
        return new BiLeftHandSide<A, B>(new DetachedPatternVariable(newA), bPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutput));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new TriLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DirectPatternVariable(accumulateOutput, prerequisites), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new QuadLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, prerequisites), this.variableFactory);
    }

    private <NewA, NewB, NewC> Function2<A, B, TriTuple<NewA, NewB, NewC>> createCompositeTriGroupKey(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiFunction<A, B, NewC> keyMappingC) {
        return (Function2 & Serializable)(a, b) -> new TriTuple(keyMappingA.apply(a, b), keyMappingB.apply(a, b), keyMappingC.apply(a, b));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiFunction<A, B, NewC> keyMappingC) {
        Variable<TriTuple> groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        IndirectPatternVariable<Object, TriTuple> cPatternVar = new IndirectPatternVariable<Object, TriTuple>(tuplePatternVar, newC, tuple -> tuple.c);
        return new TriLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiFunction<A, B, NewC> keyMappingC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        Variable<TriTuple> groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new QuadLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(newC), new DirectPatternVariable(accumulateOutputD, prerequisites), this.variableFactory);
    }

    private <NewA, NewB, NewC, NewD> Function2<A, B, QuadTuple<NewA, NewB, NewC, NewD>> createCompositeQuadGroupKey(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiFunction<A, B, NewC> keyMappingC, BiFunction<A, B, NewD> keyMappingD) {
        return (Function2 & Serializable)(a, b) -> new QuadTuple(keyMappingA.apply(a, b), keyMappingB.apply(a, b), keyMappingC.apply(a, b), keyMappingD.apply(a, b));
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiFunction<A, B, NewC> keyMappingC, BiFunction<A, B, NewD> keyMappingD) {
        Variable<QuadTuple> groupKey = this.variableFactory.createVariable(QuadTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeQuadGroupKey(keyMappingA, keyMappingB, keyMappingC, keyMappingD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        Variable newD = this.variableFactory.createVariable("newD");
        DirectPatternVariable tuplePatternVar = BiLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC, newD);
        IndirectPatternVariable<Object, QuadTuple> dPatternVar = new IndirectPatternVariable<Object, QuadTuple>(tuplePatternVar, newD, tuple -> tuple.d);
        return new QuadLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(newC), dPatternVar, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andMap(BiFunction<A, B, NewA> mapping) {
        Variable<NewA> newA = this.variableFactory.createVariable("mapped", this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), mapping);
        List<ViewItem<?>> allPrerequisites = BiLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB);
        DirectPatternVariable<NewA> newPatternVariableA = new DirectPatternVariable<NewA>(newA, allPrerequisites);
        return new UniLeftHandSide(this, newPatternVariableA);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntBiFunction<A, B> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongBiFunction<A, B> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(BiFunction<A, B, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    private ViewItem<?> buildAccumulate(Variable<BiTuple<A, B>> accumulateSource, AccumulateFunction ... accFunctions) {
        Object newPatternVariableB = this.patternVariableB.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), (b, a) -> new BiTuple<Object, Object>(a, b));
        ViewItem<?> innerAccumulatePattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(new PatternVariable[]{this.patternVariableA, newPatternVariableB});
        return BiLeftHandSide.buildAccumulate(innerAccumulatePattern, accFunctions);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<GroupKey_> groupKey, Function2<A, B, GroupKey_> groupKeyExtractor) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB);
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, groupKeyExtractor, (AccumulateFunction[])new AccumulateFunction[0]);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<BiTuple<A, B>> accumulateSource, Variable<GroupKey_> groupKey, Function2<A, B, GroupKey_> groupKeyExtractor, AccumulateFunction ... accFunctions) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Object newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(new PatternVariable[]{this.patternVariableA, newPatternVariableB});
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, groupKeyExtractor, (AccumulateFunction[])accFunctions);
    }
}

