/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.config;

import io.quarkus.runtime.configuration.ArrayListFactory;
import io.smallrye.config.SmallRyeConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.optaweb.vehiclerouting.plugin.routing.RoutingProperties;
import org.optaweb.vehiclerouting.service.demo.DemoProperties;
import org.optaweb.vehiclerouting.service.region.RegionProperties;

@Singleton
public class ConfigPropertiesProducer {
    @Produces
    @Default
    public RegionProperties produceRegionProperties(Config config) {
        RegionProperties regionProperties = new RegionProperties();
        SmallRyeConfig smallRyeConfig = (SmallRyeConfig)config;
        ArrayListFactory arrayListFactory = ArrayListFactory.getInstance();
        Optional optional = smallRyeConfig.getOptionalValues("app.region.country-codes", String.class, (IntFunction)arrayListFactory);
        if (optional.isPresent()) {
            Object t = optional.get();
            regionProperties.setCountryCodes((List)t);
        }
        return regionProperties;
    }

    @Produces
    @Default
    public RoutingProperties produceRoutingProperties(Config config) {
        RoutingProperties routingProperties = new RoutingProperties();
        Optional optional = config.getOptionalValue("app.routing.engine", RoutingProperties.RoutingEngine.class);
        if (optional.isPresent()) {
            Object t = optional.get();
            routingProperties.setEngine((RoutingProperties.RoutingEngine)t);
        }
        Optional optional2 = config.getOptionalValue("app.routing.gh-dir", String.class);
        if (optional2.isPresent()) {
            Object t = optional2.get();
            routingProperties.setGhDir((String)t);
        }
        Optional optional3 = config.getOptionalValue("app.routing.osm-dir", String.class);
        if (optional3.isPresent()) {
            Object t = optional3.get();
            routingProperties.setOsmDir((String)t);
        }
        Optional optional4 = config.getOptionalValue("app.routing.osm-download-url", String.class);
        routingProperties.setOsmDownloadUrl(optional4);
        Optional optional5 = config.getOptionalValue("app.routing.osm-file", String.class);
        if (optional5.isPresent()) {
            Object t = optional5.get();
            routingProperties.setOsmFile((String)t);
        }
        return routingProperties;
    }

    @Produces
    @Default
    public DemoProperties produceDemoProperties(Config config) {
        DemoProperties demoProperties = new DemoProperties();
        Optional optional = config.getOptionalValue("app.demo.data-set-dir", String.class);
        demoProperties.setDataSetDir(optional);
        return demoProperties;
    }
}

