/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.vehicle;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.service.vehicle.VehiclePlanner;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;

@ApplicationScoped
public class VehicleService {
    static final int DEFAULT_VEHICLE_CAPACITY = 10;
    private final VehiclePlanner planner;
    private final VehicleRepository vehicleRepository;

    public VehicleService() {
    }

    @Inject
    public VehicleService(VehiclePlanner planner, VehicleRepository vehicleRepository) {
        this.planner = planner;
        this.vehicleRepository = vehicleRepository;
    }

    @Transactional
    public Vehicle createVehicle() {
        Vehicle vehicle = this.vehicleRepository.createVehicle(10);
        this.addVehicle(vehicle);
        return vehicle;
    }

    @Transactional
    public Vehicle createVehicle(VehicleData vehicleData) {
        Vehicle vehicle = this.vehicleRepository.createVehicle(vehicleData);
        this.addVehicle(vehicle);
        return vehicle;
    }

    public void addVehicle(Vehicle vehicle) {
        this.planner.addVehicle(Objects.requireNonNull(vehicle));
    }

    @Transactional
    public void removeVehicle(long vehicleId) {
        Vehicle vehicle = this.vehicleRepository.removeVehicle(vehicleId);
        this.planner.removeVehicle(vehicle);
    }

    public synchronized void removeAnyVehicle() {
        Optional<Vehicle> first = this.vehicleRepository.vehicles().stream().min(Comparator.comparingLong(Vehicle::id));
        first.map(Vehicle::id).ifPresent(this::removeVehicle);
    }

    @Transactional
    public void removeAll() {
        this.planner.removeAllVehicles();
        this.vehicleRepository.removeAll();
    }

    @Transactional
    public void changeCapacity(long vehicleId, int capacity) {
        Vehicle updatedVehicle = this.vehicleRepository.changeCapacity(vehicleId, capacity);
        this.planner.changeCapacity(updatedVehicle);
    }
}

