/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Default;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.jboss.logging.Logger;

public final class HibernateCurrentTenantIdentifierResolver
implements CurrentTenantIdentifierResolver {
    private static final Logger LOG = Logger.getLogger(HibernateCurrentTenantIdentifierResolver.class);
    private final String persistenceUnitName;

    public HibernateCurrentTenantIdentifierResolver(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String resolveCurrentTenantIdentifier() {
        if (!Arc.container().requestContext().isActive()) {
            return null;
        }
        TenantResolver resolver = HibernateCurrentTenantIdentifierResolver.tenantResolver(this.persistenceUnitName);
        String tenantId = resolver.resolveTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Method 'TenantResolver.resolveTenantId()' returned a null value. Unfortunately Hibernate ORM does not allow null for tenant identifiers. Please use a non-null value!");
        }
        LOG.debugv("resolveCurrentTenantIdentifier(): {0}", (Object)tenantId);
        return tenantId;
    }

    public boolean validateExistingCurrentSessions() {
        return false;
    }

    private static TenantResolver tenantResolver(String persistenceUnitName) {
        InstanceHandle resolverInstance = PersistenceUnitUtil.isDefaultPersistenceUnit(persistenceUnitName) ? Arc.container().instance(TenantResolver.class, new Annotation[]{Default.Literal.INSTANCE}) : Arc.container().instance(TenantResolver.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistenceUnitName)});
        if (!resolverInstance.isAvailable()) {
            throw new IllegalStateException(String.format("No instance of %1$s was found for persistence unit %2$s. You need to create an implementation for this interface to allow resolving the current tenant identifier.", TenantResolver.class.getSimpleName(), persistenceUnitName));
        }
        return (TenantResolver)resolverInstance.get();
    }
}

