/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.GHIntHashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class GHSortedCollection {
    private final int slidingMeanValue = 20;
    private final TreeMap<Integer, GHIntHashSet> map = new TreeMap();
    private int size;

    public void clear() {
        this.size = 0;
        this.map.clear();
    }

    void remove(int key, int value) {
        GHIntHashSet set = this.map.get(value);
        if (set == null || !set.remove(key)) {
            throw new IllegalStateException("cannot remove key " + key + " with value " + value + " - did you insert " + key + "," + value + " before?");
        }
        --this.size;
        if (set.isEmpty()) {
            this.map.remove(value);
        }
    }

    public void update(int key, int oldValue, int value) {
        this.remove(key, oldValue);
        this.insert(key, value);
    }

    public void insert(int key, int value) {
        GHIntHashSet set = this.map.get(value);
        if (set == null) {
            set = new GHIntHashSet(20);
            this.map.put(value, set);
        }
        if (!set.add(key)) {
            throw new IllegalStateException("use update if you want to update " + key);
        }
        ++this.size;
    }

    public int peekValue() {
        if (this.size == 0) {
            throw new IllegalStateException("collection is already empty!?");
        }
        Map.Entry<Integer, GHIntHashSet> e = this.map.firstEntry();
        if (e.getValue().isEmpty()) {
            throw new IllegalStateException("internal set is already empty!?");
        }
        return this.map.firstEntry().getKey();
    }

    public int peekKey() {
        if (this.size == 0) {
            throw new IllegalStateException("collection is already empty!?");
        }
        GHIntHashSet set = this.map.firstEntry().getValue();
        if (set.isEmpty()) {
            throw new IllegalStateException("internal set is already empty!?");
        }
        return ((IntCursor)set.iterator().next()).value;
    }

    public int pollKey() {
        --this.size;
        if (this.size < 0) {
            throw new IllegalStateException("collection is already empty!?");
        }
        Map.Entry<Integer, GHIntHashSet> e = this.map.firstEntry();
        GHIntHashSet set = e.getValue();
        if (set.isEmpty()) {
            throw new IllegalStateException("internal set is already empty!?");
        }
        Iterator iter = set.iterator();
        int val = ((IntCursor)iter.next()).value;
        set.remove(val);
        if (set.isEmpty()) {
            this.map.remove(e.getKey());
        }
        return val;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getSlidingMeanValue() {
        return 20;
    }

    public String toString() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Map.Entry<Integer, GHIntHashSet> e : this.map.entrySet()) {
            int tmpSize = e.getValue().size();
            if (min > tmpSize) {
                min = tmpSize;
            }
            if (max >= tmpSize) continue;
            max = tmpSize;
        }
        String str = "";
        if (!this.isEmpty()) {
            str = ", minEntry=(" + this.peekKey() + "=>" + this.peekValue() + ")";
        }
        return "size=" + this.size + ", treeMap.size=" + this.map.size() + ", averageNo=" + (float)this.size * 1.0f / (float)this.map.size() + ", minNo=" + min + ", maxNo=" + max + str;
    }
}

