/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.InstructionsOutgoingEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;

public class InstructionsFromEdges
implements Path.EdgeVisitor {
    private final Weighting weighting;
    private final FlagEncoder encoder;
    private final NodeAccess nodeAccess;
    private final Translation tr;
    private final InstructionList ways;
    private final EdgeExplorer outEdgeExplorer;
    private final EdgeExplorer crossingExplorer;
    private final BooleanEncodedValue roundaboutEnc;
    private final BooleanEncodedValue accessEnc;
    private EdgeIteratorState prevEdge;
    private double prevLat;
    private double prevLon;
    private double doublePrevLat;
    private double doublePrevLon;
    private int prevNode;
    private double prevOrientation;
    private double prevInstructionPrevOrientation = Double.NaN;
    private Instruction prevInstruction;
    private boolean prevInRoundabout;
    private String prevName;
    private String prevInstructionName;
    private InstructionAnnotation prevAnnotation;
    private final int MAX_U_TURN_DISTANCE = 35;

    public InstructionsFromEdges(int tmpNode, Graph graph, Weighting weighting, FlagEncoder encoder, BooleanEncodedValue roundaboutEnc, NodeAccess nodeAccess, Translation tr, InstructionList ways) {
        this.weighting = weighting;
        this.encoder = encoder;
        this.accessEnc = encoder.getAccessEnc();
        this.roundaboutEnc = roundaboutEnc;
        this.nodeAccess = nodeAccess;
        this.tr = tr;
        this.ways = ways;
        this.prevLat = this.nodeAccess.getLatitude(tmpNode);
        this.prevLon = this.nodeAccess.getLongitude(tmpNode);
        this.prevNode = -1;
        this.prevInRoundabout = false;
        this.prevName = null;
        this.outEdgeExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(encoder));
        this.crossingExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.allEdges(encoder));
    }

    @Override
    public void next(EdgeIteratorState edge, int index, int prevEdgeId) {
        int sign;
        double longitude;
        double latitude;
        int adjNode = edge.getAdjNode();
        int baseNode = edge.getBaseNode();
        IntsRef flags = edge.getFlags();
        double adjLat = this.nodeAccess.getLatitude(adjNode);
        double adjLon = this.nodeAccess.getLongitude(adjNode);
        PointList wayGeo = edge.fetchWayGeometry(3);
        boolean isRoundabout = this.roundaboutEnc.getBool(false, flags);
        if (wayGeo.getSize() <= 2) {
            latitude = adjLat;
            longitude = adjLon;
        } else {
            latitude = wayGeo.getLatitude(1);
            longitude = wayGeo.getLongitude(1);
            assert (Double.compare(this.prevLat, this.nodeAccess.getLatitude(baseNode)) == 0);
            assert (Double.compare(this.prevLon, this.nodeAccess.getLongitude(baseNode)) == 0);
        }
        String name = edge.getName();
        InstructionAnnotation annotation = this.encoder.getAnnotation(flags, this.tr);
        if (this.prevName == null && !isRoundabout) {
            sign = 0;
            this.prevInstruction = new Instruction(sign, name, annotation, new PointList(10, this.nodeAccess.is3D()));
            double startLat = this.nodeAccess.getLat(baseNode);
            double startLon = this.nodeAccess.getLon(baseNode);
            double heading = Helper.ANGLE_CALC.calcAzimuth(startLat, startLon, latitude, longitude);
            this.prevInstruction.setExtraInfo("heading", (Object)Helper.round((double)heading, (int)2));
            this.ways.add((Object)this.prevInstruction);
            this.prevName = name;
            this.prevAnnotation = annotation;
        } else if (isRoundabout) {
            if (!this.prevInRoundabout) {
                int sign2 = 6;
                RoundaboutInstruction roundaboutInstruction = new RoundaboutInstruction(sign2, name, annotation, new PointList(10, this.nodeAccess.is3D()));
                this.prevInstructionPrevOrientation = this.prevOrientation;
                if (this.prevName != null) {
                    EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(baseNode);
                    while (edgeIter.next()) {
                        if (edgeIter.getAdjNode() == this.prevNode || this.roundaboutEnc.getBool(false, edgeIter.getFlags())) continue;
                        roundaboutInstruction.increaseExitNumber();
                        break;
                    }
                    this.prevOrientation = Helper.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
                    double orientation = Helper.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    orientation = Helper.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
                    double delta = orientation - this.prevOrientation;
                    roundaboutInstruction.setDirOfRotation(delta);
                } else {
                    this.prevOrientation = Helper.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    this.prevName = name;
                    this.prevAnnotation = annotation;
                }
                this.prevInstruction = roundaboutInstruction;
                this.ways.add((Object)this.prevInstruction);
            }
            EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(edge.getAdjNode());
            while (edgeIter.next()) {
                if (this.roundaboutEnc.getBool(false, edgeIter.getFlags())) continue;
                ((RoundaboutInstruction)this.prevInstruction).increaseExitNumber();
                break;
            }
        } else if (this.prevInRoundabout) {
            this.prevInstruction.setName(name);
            double orientation = Helper.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
            orientation = Helper.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double deltaInOut = orientation - this.prevOrientation;
            double recentOrientation = Helper.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = Helper.ANGLE_CALC.alignOrientation(recentOrientation, orientation);
            double deltaOut = orientation - recentOrientation;
            this.prevInstruction = ((RoundaboutInstruction)this.prevInstruction).setRadian(deltaInOut).setDirOfRotation(deltaOut).setExited();
            this.prevInstructionName = this.prevName;
            this.prevName = name;
            this.prevAnnotation = annotation;
        } else {
            sign = this.getTurn(edge, baseNode, this.prevNode, adjNode, annotation, name);
            if (sign != Integer.MIN_VALUE) {
                double lon;
                GHPoint point;
                double lat;
                double currentOrientation;
                double diff;
                boolean isUTurn = false;
                int uTurnType = -98;
                if (!Double.isNaN(this.prevInstructionPrevOrientation) && this.prevInstruction.getDistance() < 35.0 && sign < 0 == this.prevInstruction.getSign() < 0 && (Math.abs(sign) == 1 || Math.abs(sign) == 2 || Math.abs(sign) == 3) && (Math.abs(this.prevInstruction.getSign()) == 1 || Math.abs(this.prevInstruction.getSign()) == 2 || Math.abs(this.prevInstruction.getSign()) == 3) && edge.get(this.accessEnc) != edge.getReverse(this.accessEnc) && InstructionsHelper.isNameSimilar(this.prevInstructionName, name) && (diff = Math.abs(this.prevInstructionPrevOrientation - (currentOrientation = Helper.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, lat = (point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess)).getLat(), lon = point.getLon(), false)))) > 2.827433388230814 && diff < 3.455751918948773) {
                    isUTurn = true;
                    uTurnType = sign < 0 ? -8 : 8;
                }
                if (isUTurn) {
                    this.prevInstruction.setSign(uTurnType);
                    this.prevInstruction.setName(name);
                } else {
                    this.prevInstruction = new Instruction(sign, name, annotation, new PointList(10, this.nodeAccess.is3D()));
                    this.prevInstructionPrevOrientation = this.prevOrientation;
                    this.prevInstructionName = this.prevName;
                    this.ways.add((Object)this.prevInstruction);
                    this.prevAnnotation = annotation;
                }
            }
            this.prevName = name;
        }
        this.updatePointsAndInstruction(edge, wayGeo);
        if (wayGeo.getSize() <= 2) {
            this.doublePrevLat = this.prevLat;
            this.doublePrevLon = this.prevLon;
        } else {
            int beforeLast = wayGeo.getSize() - 2;
            this.doublePrevLat = wayGeo.getLatitude(beforeLast);
            this.doublePrevLon = wayGeo.getLongitude(beforeLast);
        }
        this.prevInRoundabout = isRoundabout;
        this.prevNode = baseNode;
        this.prevLat = adjLat;
        this.prevLon = adjLon;
        this.prevEdge = edge;
    }

    @Override
    public void finish() {
        if (this.prevInRoundabout) {
            double orientation = Helper.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = Helper.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double delta = orientation - this.prevOrientation;
            ((RoundaboutInstruction)this.prevInstruction).setRadian(delta);
        }
        FinishInstruction finishInstruction = new FinishInstruction((PointAccess)this.nodeAccess, this.prevEdge.getAdjNode());
        finishInstruction.setExtraInfo("last_heading", (Object)Helper.ANGLE_CALC.calcAzimuth(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon));
        this.ways.add((Object)finishInstruction);
    }

    private int getTurn(EdgeIteratorState edge, int baseNode, int prevNode, int adjNode, InstructionAnnotation annotation, String name) {
        InstructionsOutgoingEdges outgoingEdges;
        int nrOfPossibleTurns;
        GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
        double lat = point.getLat();
        double lon = point.getLon();
        this.prevOrientation = Helper.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
        int sign = InstructionsHelper.calculateSign(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        boolean forceInstruction = false;
        if (!annotation.equals((Object)this.prevAnnotation) && !annotation.isEmpty()) {
            forceInstruction = true;
        }
        if ((nrOfPossibleTurns = (outgoingEdges = new InstructionsOutgoingEdges(this.prevEdge, edge, this.encoder, this.crossingExplorer, this.nodeAccess, prevNode, baseNode, adjNode)).nrOfAllowedOutgoingEdges()) <= 1) {
            if (Math.abs(sign) > 1 && outgoingEdges.nrOfAllOutgoingEdges() > 1) {
                return sign;
            }
            return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
        }
        if (Math.abs(sign) > 1) {
            if (InstructionsHelper.isNameSimilar(name, this.prevName) && outgoingEdges.outgoingEdgesAreSlowerByFactor(2.0)) {
                return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
            }
            return sign;
        }
        if (this.prevEdge == null) {
            return sign;
        }
        IntsRef flag = edge.getFlags();
        IntsRef prevFlag = this.prevEdge.getFlags();
        boolean outgoingEdgesAreSlower = outgoingEdges.outgoingEdgesAreSlowerByFactor(1.0);
        EdgeIteratorState otherContinue = outgoingEdges.getOtherContinue(this.prevLat, this.prevLon, this.prevOrientation);
        double delta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        if (!(otherContinue == null || InstructionsHelper.isNameSimilar(name, this.prevName) && !InstructionsHelper.isNameSimilar(otherContinue.getName(), this.prevName) && prevFlag.equals(flag) && !prevFlag.equals(otherContinue.getFlags()) && outgoingEdgesAreSlower)) {
            GHPoint tmpPoint = InstructionsHelper.getPointForOrientationCalculation(otherContinue, this.nodeAccess);
            double otherDelta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, tmpPoint.getLat(), tmpPoint.getLon(), this.prevOrientation);
            if (Math.abs(delta) < 0.1 && Math.abs(otherDelta) > 0.15 && InstructionsHelper.isNameSimilar(name, this.prevName)) {
                return 0;
            }
            if (otherDelta < delta) {
                return -7;
            }
            return 7;
        }
        if (!outgoingEdgesAreSlower && (Math.abs(delta) > 0.4 || outgoingEdges.isLeavingCurrentStreet(this.prevName, name))) {
            return sign;
        }
        return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
    }

    private int returnForcedInstructionOrIgnore(boolean forceInstruction, int sign) {
        if (forceInstruction) {
            return sign;
        }
        return Integer.MIN_VALUE;
    }

    private void updatePointsAndInstruction(EdgeIteratorState edge, PointList pl) {
        int len = pl.size() - 1;
        for (int i = 0; i < len; ++i) {
            this.prevInstruction.getPoints().add((PointAccess)pl, i);
        }
        double newDist = edge.getDistance();
        this.prevInstruction.setDistance(newDist + this.prevInstruction.getDistance());
        this.prevInstruction.setTime(this.weighting.calcMillis(edge, false, -1) + this.prevInstruction.getTime());
    }
}

