/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleContainer;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpatialRuleLookupArray
implements SpatialRuleLookup {
    private final double resolution;
    private final double checkDiff;
    private final BBox bounds;
    private final boolean exact;
    private final int EMPTY_RULE_INDEX = 0;
    private final byte[][] lookupArray;
    private final List<SpatialRuleContainer> ruleContainers = new ArrayList<SpatialRuleContainer>();
    private final Map<SpatialRule, Integer> singleRulesIndices = new HashMap<SpatialRule, Integer>();
    private final List<SpatialRule> singleRules = new ArrayList<SpatialRule>();

    public SpatialRuleLookupArray(List<SpatialRule> spatialRules, double resolution, boolean exact, BBox bounds) {
        if (!bounds.isValid()) {
            throw new IllegalStateException("Bounds are not valid: " + bounds);
        }
        this.bounds = bounds;
        if (resolution < 1.0E-100) {
            throw new IllegalArgumentException("resolution cannot be that high " + resolution);
        }
        this.resolution = resolution;
        this.checkDiff = resolution / 2.0 - resolution / 10.0;
        this.exact = exact;
        this.lookupArray = new byte[this.getNumberOfXGrids()][this.getNumberOfYGrids()];
        this.addSingleRule(SpatialRule.EMPTY);
        this.ruleContainers.add(new SpatialRuleContainer(){
            {
                this.rules.add(SpatialRule.EMPTY);
            }

            @Override
            public SpatialRuleContainer addRule(SpatialRule spatialRule) {
                throw new IllegalArgumentException("Cannot add to empty rule container");
            }

            @Override
            public SpatialRuleContainer addRules(Collection<SpatialRule> rules) {
                throw new IllegalArgumentException("Cannot add to empty rule container");
            }
        });
        for (SpatialRule spatialRule : spatialRules) {
            this.addRuleInternal(spatialRule);
        }
    }

    private int getNumberOfYGrids() {
        return (int)Math.ceil(Math.abs(this.bounds.maxLat - this.bounds.minLat) / this.resolution);
    }

    private int getNumberOfXGrids() {
        return (int)Math.ceil(Math.abs(this.bounds.maxLon - this.bounds.minLon) / this.resolution);
    }

    @Override
    public SpatialRule lookupRule(double lat, double lon) {
        int yIndex;
        if (lon < this.bounds.minLon || lon > this.bounds.maxLon || lat < this.bounds.minLat || lat > this.bounds.maxLat) {
            return SpatialRule.EMPTY;
        }
        int xIndex = this.getXIndexForLon(lon);
        int ruleIndex = this.getRuleContainerIndex(xIndex, yIndex = this.getYIndexForLat(lat));
        SpatialRuleContainer ruleContainer = this.ruleContainers.get(ruleIndex);
        if (!(ruleContainer.size() != 1 || this.exact && this.isBorderTile(xIndex, yIndex, ruleIndex))) {
            return ruleContainer.first();
        }
        for (SpatialRule rule : ruleContainer.getRules()) {
            if (rule.equals(SpatialRule.EMPTY)) continue;
            for (Polygon p : rule.getBorders()) {
                if (!p.contains(lat, lon)) continue;
                return rule;
            }
        }
        return SpatialRule.EMPTY;
    }

    private int getRuleContainerIndex(int xIndex, int yIndex) {
        if (xIndex < 0 || xIndex >= this.lookupArray.length) {
            return 0;
        }
        if (yIndex < 0 || yIndex >= this.lookupArray[0].length) {
            return 0;
        }
        return this.castByteToInt(this.lookupArray[xIndex][yIndex]);
    }

    private boolean isBorderTile(int xIndex, int yIndex, int ruleIndex) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == xIndex || j == yIndex || ruleIndex == this.getRuleContainerIndex(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SpatialRule lookupRule(GHPoint point) {
        return this.lookupRule(point.getLat(), point.getLon());
    }

    private int getXIndexForLon(double lon) {
        if (lon < this.bounds.minLon) {
            return 0;
        }
        return (int)Math.floor(Math.abs(lon - this.bounds.minLon) / this.resolution);
    }

    private int getYIndexForLat(double lat) {
        if (lat < this.bounds.minLat) {
            return 0;
        }
        return (int)Math.floor(Math.abs(lat - this.bounds.minLat) / this.resolution);
    }

    private void addRuleInternal(SpatialRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        if (rule.equals(SpatialRule.EMPTY)) {
            throw new IllegalArgumentException("rule cannot be EMPTY");
        }
        this.addSingleRule(rule);
        int ruleContainerIndex = this.addRuleContainer(new SpatialRuleContainer().addRule(rule));
        for (Polygon polygon : rule.getBorders()) {
            for (int xIdx = this.getXIndexForLon(polygon.getMinLon()); xIdx < this.getXIndexForLon(polygon.getMaxLon()) + 1; ++xIdx) {
                for (int yIdx = this.getYIndexForLat(polygon.getMinLat()); yIdx < this.getYIndexForLat(polygon.getMaxLat()) + 1; ++yIdx) {
                    GHPoint center;
                    if (xIdx >= this.lookupArray.length || yIdx >= this.lookupArray[0].length || !polygon.contains(center = this.getCoordinatesForIndex(xIdx, yIdx)) && !polygon.contains(center.getLat() - this.checkDiff, center.getLon() - this.checkDiff) && !polygon.contains(center.getLat() - this.checkDiff, center.getLon() + this.checkDiff) && !polygon.contains(center.getLat() + this.checkDiff, center.getLon() - this.checkDiff) && !polygon.contains(center.getLat() + this.checkDiff, center.getLon() + this.checkDiff)) continue;
                    if (this.lookupArray[xIdx][yIdx] == 0) {
                        this.lookupArray[xIdx][yIdx] = (byte)ruleContainerIndex;
                        continue;
                    }
                    SpatialRuleContainer curContainer = this.getContainerFor2DIndex(xIdx, yIdx);
                    SpatialRuleContainer newContainer = curContainer.copy().addRule(rule);
                    int newRuleContainerIndex = this.addRuleContainer(newContainer);
                    this.lookupArray[xIdx][yIdx] = (byte)newRuleContainerIndex;
                }
            }
        }
    }

    private void addSingleRule(SpatialRule rule) {
        int index = this.singleRules.indexOf(rule);
        if (index >= 0) {
            throw new IllegalArgumentException("Rule " + rule + " already contained at " + index + ". " + (index >= this.ruleContainers.size() ? "" : "Existing:" + this.ruleContainers.get(index)));
        }
        this.singleRulesIndices.put(rule, this.singleRules.size());
        this.singleRules.add(rule);
    }

    @Override
    public SpatialRule getSpatialRule(int id) {
        if (id < 0 || id >= this.ruleContainers.size()) {
            throw new IllegalArgumentException("SpatialRuleId " + id + " is illegal");
        }
        SpatialRule rule = this.singleRules.get(id);
        if (rule == null) {
            throw new IllegalArgumentException("SpatialRuleId " + id + " not found");
        }
        return rule;
    }

    private int addRuleContainer(SpatialRuleContainer container) {
        int newIndex = this.ruleContainers.indexOf(container);
        if (newIndex >= 0) {
            return newIndex;
        }
        newIndex = this.ruleContainers.size();
        if (newIndex >= 255) {
            throw new IllegalStateException("No more spatial rule container fit into this lookup as 255 combination of ruleContainers reached");
        }
        this.ruleContainers.add(container);
        return newIndex;
    }

    @Override
    public int getSpatialId(SpatialRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule parameter cannot be null");
        }
        Integer integ = this.singleRulesIndices.get(rule);
        if (integ == null) {
            throw new IllegalArgumentException("Cannot find rule " + rule);
        }
        return integ;
    }

    private int castByteToInt(byte b) {
        return b & 0xFF;
    }

    private SpatialRuleContainer getContainerFor2DIndex(int x, int y) {
        return this.ruleContainers.get(this.getRuleContainerIndex(x, y));
    }

    private GHPoint getCoordinatesForIndex(int x, int y) {
        double lon = this.bounds.minLon + (double)x * this.resolution + this.resolution / 2.0;
        double lat = this.bounds.minLat + (double)y * this.resolution + this.resolution / 2.0;
        return new GHPoint(lat, lon);
    }

    @Override
    public int size() {
        return this.singleRules.size();
    }

    @Override
    public BBox getBounds() {
        return this.bounds;
    }
}

