/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

public class PostgreSqlServiceBindingConverter
implements ServiceBindingConverter {
    private static final Logger log = Logger.getLogger(ServiceBinding.class);

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)"postgresql", serviceBindings);
        if (!matchingByType.isPresent()) {
            return Optional.empty();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        String username = (String)binding.getProperties().get("username");
        if (username != null) {
            properties.put("quarkus.datasource.username", username);
        } else {
            log.debug((Object)"Property 'username' was not found");
        }
        String password = (String)binding.getProperties().get("password");
        if (password != null) {
            properties.put("quarkus.datasource.password", password);
        } else {
            log.debug((Object)"Property 'password' was not found");
        }
        String host = (String)binding.getProperties().get("host");
        String port = (String)binding.getProperties().get("port");
        String database = (String)binding.getProperties().get("database");
        if (host != null && database != null) {
            String portPart = "";
            if (port != null) {
                portPart = ":" + port;
            }
            properties.put("quarkus.datasource.jdbc.url", String.format("jdbc:postgresql://%s%s/%s", host, portPart, database));
        } else {
            log.debug((Object)"One or more of 'host' or 'database' properties were not found");
        }
        return Optional.of(new ServiceBindingConfigSource("postgresql-k8s-service-binding-source", properties));
    }
}

