/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;

public final class ReflectionFieldMemberAccessor
implements MemberAccessor {
    private final Field field;

    public ReflectionFieldMemberAccessor(Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public Object executeGetter(Object bean) {
        try {
            return this.field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot get the field (" + this.field.getName() + ") on bean of class (" + bean.getClass() + ").\n" + MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE, e);
        }
    }

    @Override
    public boolean supportSetter() {
        return true;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        try {
            this.field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set the field (" + this.field.getName() + ") on bean of class (" + bean.getClass() + ").", e);
        }
    }

    @Override
    public String getSpeedNote() {
        return "slow access with reflection";
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.field.getDeclaredAnnotations();
    }

    public String toString() {
        return "field " + this.field;
    }
}

