/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;

public class GizmoMemberAccessorFactory {
    private static Map<String, MemberAccessor> memberAccessorMap = new HashMap<String, MemberAccessor>();

    public static String getGeneratedClassName(Member member) {
        String memberName = (String)ObjectUtils.defaultIfNull((Object)ReflectionHelper.getGetterPropertyName(member), (Object)member.getName());
        String memberType = member instanceof Field ? "Field" : "Method";
        return member.getDeclaringClass().getName() + "$OptaPlanner$MemberAccessor$" + memberType + "$" + memberName;
    }

    public static void usePregeneratedMemberAccessorMap(Map<String, MemberAccessor> memberAccessorMap) {
        GizmoMemberAccessorFactory.memberAccessorMap = memberAccessorMap;
    }

    public static MemberAccessor buildGizmoMemberAccessor(Member member, Class<? extends Annotation> annotationClass) {
        String gizmoMemberAccessorClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        return memberAccessorMap.computeIfAbsent(gizmoMemberAccessorClassName, key -> {
            try {
                Class.forName("io.quarkus.gizmo.ClassCreator", false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("When using the domainAccessType (" + (Object)((Object)DomainAccessType.GIZMO) + ") the classpath or modulepath must contain io.quarkus.gizmo:gizmo.\nMaybe add a dependency to io.quarkus.gizmo:gizmo.");
            }
            MemberAccessor accessor = GizmoMemberAccessorImplementor.createAccessorFor(member, annotationClass);
            return accessor;
        });
    }

    private GizmoMemberAccessorFactory() {
    }
}

