/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.spies.Spy;
import io.smallrye.mutiny.helpers.spies.UniOnCancellationSpy;
import io.smallrye.mutiny.helpers.spies.UniOnFailureSpy;
import io.smallrye.mutiny.helpers.spies.UniOnItemOrFailureSpy;
import io.smallrye.mutiny.helpers.spies.UniOnItemSpy;
import io.smallrye.mutiny.helpers.spies.UniOnSubscribeSpy;
import io.smallrye.mutiny.helpers.spies.UniOnTerminationSpy;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.subscription.UniSubscriber;

public class UniGlobalSpy<T>
extends UniSpyBase<T> {
    private final UniOnCancellationSpy<T> onCancellationSpy;
    private final UniOnFailureSpy<T> onFailureSpy;
    private final UniOnItemOrFailureSpy<T> onItemOrFailureSpy;
    private final UniOnItemSpy<T> onItemSpy;
    private final UniOnSubscribeSpy<T> onSubscribeSpy;
    private final UniOnTerminationSpy<T> onTerminationSpy;

    UniGlobalSpy(Uni<T> upstream) {
        super(upstream);
        this.onCancellationSpy = Spy.onCancellation(upstream);
        this.onFailureSpy = Spy.onFailure(this.onCancellationSpy);
        this.onItemOrFailureSpy = Spy.onItemOrFailure(this.onFailureSpy);
        this.onItemSpy = Spy.onItem(this.onItemOrFailureSpy);
        this.onSubscribeSpy = Spy.onSubscribe(this.onItemSpy);
        this.onTerminationSpy = Spy.onTermination(this.onSubscribeSpy);
    }

    public UniOnCancellationSpy<T> onCancellationSpy() {
        return this.onCancellationSpy;
    }

    public UniOnFailureSpy<T> onFailureSpy() {
        return this.onFailureSpy;
    }

    public UniOnItemOrFailureSpy<T> onItemOrFailureSpy() {
        return this.onItemOrFailureSpy;
    }

    public UniOnItemSpy<T> onItemSpy() {
        return this.onItemSpy;
    }

    public UniOnSubscribeSpy<T> onSubscribeSpy() {
        return this.onSubscribeSpy;
    }

    public UniOnTerminationSpy<T> onTerminationSpy() {
        return this.onTerminationSpy;
    }

    @Override
    public long invocationCount() {
        return this.onCancellationSpy.invocationCount() + this.onFailureSpy.invocationCount() + this.onItemSpy.invocationCount() + this.onItemOrFailureSpy.invocationCount() + this.onSubscribeSpy.invocationCount() + this.onTerminationSpy.invocationCount();
    }

    @Override
    public boolean invoked() {
        return this.invocationCount() > 0L;
    }

    @Override
    public void reset() {
        this.onCancellationSpy.reset();
        this.onFailureSpy.reset();
        this.onItemSpy.reset();
        this.onItemOrFailureSpy.reset();
        this.onSubscribeSpy.reset();
        this.onTerminationSpy.reset();
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> downstream) {
        this.onTerminationSpy.subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniGlobalSpy{onCancellationSpy=" + this.onCancellationSpy + ", onFailureSpy=" + this.onFailureSpy + ", onItemOrFailureSpy=" + this.onItemOrFailureSpy + ", onItemSpy=" + this.onItemSpy + ", onSubscribeSpy=" + this.onSubscribeSpy + ", onTerminationSpy=" + this.onTerminationSpy + "} " + super.toString();
    }
}

