/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.json;

import io.vertx.core.ServiceHelper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.spi.json.JacksonCodecLoader;
import java.util.ArrayList;
import java.util.Comparator;

public interface JsonCodec {
    public static final JsonCodec INSTANCE = JsonCodec.loadCodec();

    public static JsonCodec loadCodec() {
        ArrayList<JsonCodec> factories = new ArrayList<JsonCodec>(ServiceHelper.loadFactories(JsonCodec.class));
        factories.sort(Comparator.comparingInt(JsonCodec::order));
        if (factories.size() > 0) {
            return (JsonCodec)factories.iterator().next();
        }
        return JacksonCodecLoader.loadJacksonCodec();
    }

    default public int order() {
        return Integer.MAX_VALUE;
    }

    public <T> T fromString(String var1, Class<T> var2) throws DecodeException;

    public <T> T fromBuffer(Buffer var1, Class<T> var2) throws DecodeException;

    public <T> T fromValue(Object var1, Class<T> var2);

    default public String toString(Object object) throws EncodeException {
        return this.toString(object, false);
    }

    public String toString(Object var1, boolean var2) throws EncodeException;

    public Buffer toBuffer(Object var1, boolean var2) throws EncodeException;

    default public Buffer toBuffer(Object object) throws EncodeException {
        return this.toBuffer(object, false);
    }
}

