/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.Variable;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;

abstract class AbstractLeftHandSide {
    protected final DroolsVariableFactory variableFactory;

    protected AbstractLeftHandSide(DroolsVariableFactory variableFactory) {
        this.variableFactory = Objects.requireNonNull(variableFactory);
    }

    protected static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }

    protected static ViewItem<?> joinViewItemsWithLogicalAnd(PatternVariable<?, ?, ?> ... patternVariables) {
        List<ViewItem<?>> viewItemList = AbstractLeftHandSide.mergeViewItems(patternVariables);
        int viewItemListSize = viewItemList.size();
        ViewItem<?> firstPattern = viewItemList.get(0);
        if (viewItemListSize == 1) {
            return firstPattern;
        }
        ViewItem[] remainingPatternArray = viewItemList.subList(1, viewItemListSize).toArray(new ViewItem[0]);
        return DSL.and(firstPattern, (ViewItemBuilder[])remainingPatternArray);
    }

    protected static List<ViewItem<?>> mergeViewItems(PatternVariable<?, ?, ?> ... patternVariables) {
        ArrayList viewItemList = new ArrayList();
        for (PatternVariable<?, ?, ?> patternVariable : patternVariables) {
            viewItemList.addAll(patternVariable.build());
        }
        return viewItemList;
    }

    protected static <A, B> DirectPatternVariable<BiTuple<A, B>> decompose(Variable<BiTuple<A, B>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB) {
        return ((DirectPatternVariable)new DirectPatternVariable<BiTuple<A, B>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b);
    }

    protected static <A, B, C> DirectPatternVariable<TriTuple<A, B, C>> decompose(Variable<TriTuple<A, B, C>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> boundVarC) {
        return ((DirectPatternVariable)((DirectPatternVariable)new DirectPatternVariable<TriTuple<A, B, C>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b)).bind((Variable)boundVarC, tuple -> tuple.c);
    }

    protected static <A, B, C, D> DirectPatternVariable<QuadTuple<A, B, C, D>> decompose(Variable<QuadTuple<A, B, C, D>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> boundVarC, Variable<D> boundVarD) {
        return ((DirectPatternVariable)((DirectPatternVariable)((DirectPatternVariable)new DirectPatternVariable<QuadTuple<A, B, C, D>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b)).bind((Variable)boundVarC, tuple -> tuple.c)).bind((Variable)boundVarD, tuple -> tuple.d);
    }

    protected static ViewItem<?> buildAccumulate(ViewItem<?> innerAccumulatePattern, AccumulateFunction ... accFunctions) {
        if (accFunctions.length == 0) {
            throw new IllegalStateException("Impossible state: no accumulate functions provided.");
        }
        if (accFunctions.length == 1) {
            return DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)accFunctions[0], (AccumulateFunction[])new AccumulateFunction[0]);
        }
        return DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)accFunctions[0], (AccumulateFunction[])((AccumulateFunction[])Arrays.stream(accFunctions).skip(1L).toArray(AccumulateFunction[]::new)));
    }
}

