/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationInterpolator;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.PointList;

public class NodeElevationInterpolator {
    private final GraphHopperStorage storage;
    private final ElevationInterpolator elevationInterpolator = new ElevationInterpolator();

    public NodeElevationInterpolator(GraphHopperStorage storage) {
        this.storage = storage;
    }

    public void interpolateElevationsOfInnerNodes(int[] outerNodeIds, int[] innerNodeIds) {
        int numberOfOuterNodes = outerNodeIds.length;
        if (numberOfOuterNodes != 0) {
            if (numberOfOuterNodes == 1) {
                this.interpolateElevationsOfInnerNodesForOneOuterNode(outerNodeIds[0], innerNodeIds);
            } else if (numberOfOuterNodes == 2) {
                this.interpolateElevationsOfInnerNodesForTwoOuterNodes(outerNodeIds[0], outerNodeIds[1], innerNodeIds);
            } else if (numberOfOuterNodes == 3) {
                this.interpolateElevationsOfInnerNodesForThreeOuterNodes(outerNodeIds[0], outerNodeIds[1], outerNodeIds[2], innerNodeIds);
            } else if (numberOfOuterNodes > 3) {
                this.interpolateElevationsOfInnerNodesForNOuterNodes(outerNodeIds, innerNodeIds);
            }
        }
    }

    private void interpolateElevationsOfInnerNodesForOneOuterNode(int outerNodeId, int[] innerNodeIds) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double ele = nodeAccess.getEle(outerNodeId);
        for (int innerNodeId : innerNodeIds) {
            double lat = nodeAccess.getLat(innerNodeId);
            double lon = nodeAccess.getLon(innerNodeId);
            nodeAccess.setNode(innerNodeId, lat, lon, ele);
        }
    }

    private void interpolateElevationsOfInnerNodesForTwoOuterNodes(int firstOuterNodeId, int secondOuterNodeId, int[] innerNodeIds) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double lat0 = nodeAccess.getLat(firstOuterNodeId);
        double lon0 = nodeAccess.getLon(firstOuterNodeId);
        double ele0 = nodeAccess.getEle(firstOuterNodeId);
        double lat1 = nodeAccess.getLat(secondOuterNodeId);
        double lon1 = nodeAccess.getLon(secondOuterNodeId);
        double ele1 = nodeAccess.getEle(secondOuterNodeId);
        for (int innerNodeId : innerNodeIds) {
            double lat = nodeAccess.getLat(innerNodeId);
            double lon = nodeAccess.getLon(innerNodeId);
            double ele = this.elevationInterpolator.calculateElevationBasedOnTwoPoints(lat, lon, lat0, lon0, ele0, lat1, lon1, ele1);
            nodeAccess.setNode(innerNodeId, lat, lon, ele);
        }
    }

    private void interpolateElevationsOfInnerNodesForThreeOuterNodes(int firstOuterNodeId, int secondOuterNodeId, int thirdOuterNodeId, int[] innerNodeIds) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double lat0 = nodeAccess.getLat(firstOuterNodeId);
        double lon0 = nodeAccess.getLon(firstOuterNodeId);
        double ele0 = nodeAccess.getEle(firstOuterNodeId);
        double lat1 = nodeAccess.getLat(secondOuterNodeId);
        double lon1 = nodeAccess.getLon(secondOuterNodeId);
        double ele1 = nodeAccess.getEle(secondOuterNodeId);
        double lat2 = nodeAccess.getLat(thirdOuterNodeId);
        double lon2 = nodeAccess.getLon(thirdOuterNodeId);
        double ele2 = nodeAccess.getEle(thirdOuterNodeId);
        for (int innerNodeId : innerNodeIds) {
            double lat = nodeAccess.getLat(innerNodeId);
            double lon = nodeAccess.getLon(innerNodeId);
            double ele = this.elevationInterpolator.calculateElevationBasedOnThreePoints(lat, lon, lat0, lon0, ele0, lat1, lon1, ele1, lat2, lon2, ele2);
            nodeAccess.setNode(innerNodeId, lat, lon, ele);
        }
    }

    private void interpolateElevationsOfInnerNodesForNOuterNodes(int[] outerNodeIds, int[] innerNodeIds) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        PointList pointList = new PointList(outerNodeIds.length, true);
        for (int outerNodeId : outerNodeIds) {
            pointList.add(nodeAccess.getLat(outerNodeId), nodeAccess.getLon(outerNodeId), nodeAccess.getEle(outerNodeId));
        }
        for (int innerNodeId : innerNodeIds) {
            double lat = nodeAccess.getLat(innerNodeId);
            double lon = nodeAccess.getLon(innerNodeId);
            double ele = this.elevationInterpolator.calculateElevationBasedOnPointList(lat, lon, pointList);
            nodeAccess.setNode(innerNodeId, lat, lon, ele);
        }
    }
}

