/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.UnsignedIntEncodedValue;
import com.graphhopper.storage.IntsRef;

public final class SimpleBooleanEncodedValue
extends UnsignedIntEncodedValue
implements BooleanEncodedValue {
    public SimpleBooleanEncodedValue(String name) {
        this(name, false);
    }

    public SimpleBooleanEncodedValue(String name, boolean storeBothDirections) {
        super(name, 1, storeBothDirections);
    }

    @Override
    public final void setBool(boolean reverse, IntsRef ref, boolean value) {
        if (this.storeTwoDirections && reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            flags &= ~this.bwdMask;
            if (value) {
                flags |= 1 << this.bwdShift;
            }
            ref.ints[this.bwdDataIndex + ref.offset] = flags;
        } else {
            int flags = ref.ints[this.fwdDataIndex + ref.offset];
            flags &= ~this.fwdMask;
            if (value) {
                flags |= 1 << this.fwdShift;
            }
            ref.ints[this.fwdDataIndex + ref.offset] = flags;
        }
    }

    @Override
    public final boolean getBool(boolean reverse, IntsRef ref) {
        if (this.storeTwoDirections && reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            return (flags & this.bwdMask) >>> this.bwdShift == 1;
        }
        int flags = ref.ints[this.fwdDataIndex + ref.offset];
        return (flags & this.fwdMask) >>> this.fwdShift == 1;
    }
}

