/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules.countries;

import com.graphhopper.routing.profiles.Country;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.util.spatialrules.DefaultSpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;

public class AustriaSpatialRule
extends DefaultSpatialRule {
    @Override
    public double getMaxSpeed(String highwayTag, double _default) {
        switch (highwayTag) {
            case "trunk": {
                return 100.0;
            }
            case "residential": {
                return 50.0;
            }
        }
        return super.getMaxSpeed(highwayTag, _default);
    }

    @Override
    public RoadAccess getAccess(String highwayTag, TransportationMode transportationMode, RoadAccess _default) {
        if (transportationMode == TransportationMode.MOTOR_VEHICLE) {
            if (highwayTag.equals("living_street")) {
                return RoadAccess.DESTINATION;
            }
            if (highwayTag.equals("track")) {
                return RoadAccess.FORESTRY;
            }
        }
        return super.getAccess(highwayTag, transportationMode, _default);
    }

    @Override
    public String getId() {
        return Country.AUT.toString();
    }
}

