/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueFactory;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.MaxHeight;
import com.graphhopper.routing.profiles.MaxSpeed;
import com.graphhopper.routing.profiles.MaxWeight;
import com.graphhopper.routing.profiles.MaxWidth;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.profiles.RoadClass;
import com.graphhopper.routing.profiles.RoadEnvironment;
import com.graphhopper.routing.profiles.Roundabout;
import com.graphhopper.routing.profiles.SimpleBooleanEncodedValue;
import com.graphhopper.routing.profiles.Surface;
import com.graphhopper.routing.profiles.Toll;
import com.graphhopper.util.Helper;

public class DefaultEncodedValueFactory
implements EncodedValueFactory {
    @Override
    public EncodedValue create(String string) {
        EncodedValue enc;
        if (Helper.isEmpty((String)string)) {
            throw new IllegalArgumentException("No string provided to load EncodedValue");
        }
        String name = string.split("\\|")[0];
        if (name.isEmpty()) {
            throw new IllegalArgumentException("To load EncodedValue a name is required. " + string);
        }
        if ("roundabout".equals(name)) {
            enc = Roundabout.create();
        } else if ("road_class".equals(name)) {
            enc = new EnumEncodedValue<RoadClass>("road_class", RoadClass.class);
        } else if ("road_class_link".equals(name)) {
            enc = new SimpleBooleanEncodedValue("road_class_link");
        } else if ("road_environment".equals(name)) {
            enc = new EnumEncodedValue<RoadEnvironment>("road_environment", RoadEnvironment.class);
        } else if ("road_access".equals(name)) {
            enc = new EnumEncodedValue<RoadAccess>("road_access", RoadAccess.class);
        } else if ("max_speed".equals(name)) {
            enc = MaxSpeed.create();
        } else if ("max_weight".equals(name)) {
            enc = MaxWeight.create();
        } else if ("max_height".equals(name)) {
            enc = MaxHeight.create();
        } else if ("max_width".equals(name)) {
            enc = MaxWidth.create();
        } else if ("surface".equals(name)) {
            enc = new EnumEncodedValue<Surface>("surface", Surface.class);
        } else if ("toll".equals(name)) {
            enc = new EnumEncodedValue<Toll>("toll", Toll.class);
        } else {
            throw new IllegalArgumentException("DefaultEncodedValueFactory cannot find EncodedValue " + name);
        }
        return enc;
    }
}

