/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.SparseIntIntArray;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.search.NameIndex;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.GHNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.Locale;
import org.slf4j.LoggerFactory;

class BaseGraph
implements Graph {
    final DataAccess edges;
    final DataAccess nodes;
    final BBox bounds;
    final NodeAccess nodeAccess;
    final GraphExtension extStorage;
    final NameIndex nameIndex;
    final BitUtil bitUtil;
    final EncodingManager encodingManager;
    final EdgeAccess edgeAccess;
    private final int bytesForFlags;
    private final DataAccess wayGeometry;
    private final Directory dir;
    private final InternalGraphEventListener listener;
    protected int edgeCount;
    protected int N_EDGE_REF;
    protected int N_LAT;
    protected int N_LON;
    protected int N_ELE;
    protected int N_ADDITIONAL;
    int E_GEO;
    int E_NAME;
    int E_ADDITIONAL;
    int edgeEntryBytes;
    int nodeEntryBytes;
    private boolean initialized = false;
    private int nodeCount;
    private GHBitSet removedNodes;
    private int edgeEntryIndex;
    private int nodeEntryIndex;
    private long maxGeoRef;
    private boolean frozen = false;

    public BaseGraph(Directory dir, EncodingManager encodingManager, boolean withElevation, InternalGraphEventListener listener, GraphExtension extendedStorage) {
        this.dir = dir;
        this.encodingManager = encodingManager;
        this.bytesForFlags = encodingManager.getBytesForFlags();
        this.bitUtil = BitUtil.get(dir.getByteOrder());
        this.wayGeometry = dir.find("geometry");
        this.nameIndex = new NameIndex(dir);
        this.nodes = dir.find("nodes", DAType.getPreferredInt(dir.getDefaultType()));
        this.edges = dir.find("edges", DAType.getPreferredInt(dir.getDefaultType()));
        this.listener = listener;
        this.edgeAccess = new EdgeAccess(this.edges){

            @Override
            final EdgeIterable createSingleEdge(EdgeFilter filter) {
                return new EdgeIterable(BaseGraph.this, (EdgeAccess)this, filter);
            }

            @Override
            final int getEdgeRef(int nodeId) {
                return BaseGraph.this.nodes.getInt((long)nodeId * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF);
            }

            @Override
            final void setEdgeRef(int nodeId, int edgeId) {
                BaseGraph.this.nodes.setInt((long)nodeId * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF, edgeId);
            }

            @Override
            final int getEntryBytes() {
                return BaseGraph.this.edgeEntryBytes;
            }

            @Override
            final long toPointer(int edgeId) {
                assert (this.isInBounds(edgeId)) : "edgeId " + edgeId + " not in bounds [0," + BaseGraph.this.edgeCount + ")";
                return (long)edgeId * (long)BaseGraph.this.edgeEntryBytes;
            }

            @Override
            final boolean isInBounds(int edgeId) {
                return edgeId < BaseGraph.this.edgeCount && edgeId >= 0;
            }

            public String toString() {
                return "base edge access";
            }
        };
        this.bounds = BBox.createInverse((boolean)withElevation);
        this.nodeAccess = new GHNodeAccess(this, withElevation);
        this.extStorage = extendedStorage;
        this.extStorage.init(this, dir);
    }

    private static boolean isTestingEnabled() {
        boolean enableIfAssert = false;
        if (!$assertionsDisabled) {
            enableIfAssert = true;
            if (!true) {
                throw new AssertionError(true);
            }
        }
        return enableIfAssert;
    }

    @Override
    public Graph getBaseGraph() {
        return this;
    }

    void checkInit() {
        if (this.initialized) {
            throw new IllegalStateException("You cannot configure this GraphStorage after calling create or loadExisting. Calling one of the methods twice is also not allowed.");
        }
    }

    protected int loadNodesHeader() {
        this.nodeEntryBytes = this.nodes.getHeader(4);
        this.nodeCount = this.nodes.getHeader(8);
        this.bounds.minLon = Helper.intToDegree((int)this.nodes.getHeader(12));
        this.bounds.maxLon = Helper.intToDegree((int)this.nodes.getHeader(16));
        this.bounds.minLat = Helper.intToDegree((int)this.nodes.getHeader(20));
        this.bounds.maxLat = Helper.intToDegree((int)this.nodes.getHeader(24));
        if (this.bounds.hasElevation()) {
            this.bounds.minEle = Helper.intToEle((int)this.nodes.getHeader(28));
            this.bounds.maxEle = Helper.intToEle((int)this.nodes.getHeader(32));
        }
        this.frozen = this.nodes.getHeader(36) == 1;
        return 10;
    }

    protected int setNodesHeader() {
        this.nodes.setHeader(4, this.nodeEntryBytes);
        this.nodes.setHeader(8, this.nodeCount);
        this.nodes.setHeader(12, Helper.degreeToInt((double)this.bounds.minLon));
        this.nodes.setHeader(16, Helper.degreeToInt((double)this.bounds.maxLon));
        this.nodes.setHeader(20, Helper.degreeToInt((double)this.bounds.minLat));
        this.nodes.setHeader(24, Helper.degreeToInt((double)this.bounds.maxLat));
        if (this.bounds.hasElevation()) {
            this.nodes.setHeader(28, Helper.eleToInt((double)this.bounds.minEle));
            this.nodes.setHeader(32, Helper.eleToInt((double)this.bounds.maxEle));
        }
        this.nodes.setHeader(36, this.isFrozen() ? 1 : 0);
        return 10;
    }

    protected int loadEdgesHeader() {
        this.edgeEntryBytes = this.edges.getHeader(0);
        this.edgeCount = this.edges.getHeader(4);
        return 5;
    }

    protected int setEdgesHeader() {
        this.edges.setHeader(0, this.edgeEntryBytes);
        this.edges.setHeader(4, this.edgeCount);
        this.edges.setHeader(8, this.encodingManager.hashCode());
        this.edges.setHeader(12, this.extStorage.hashCode());
        return 5;
    }

    protected int loadWayGeometryHeader() {
        this.maxGeoRef = this.bitUtil.combineIntsToLong(this.wayGeometry.getHeader(0), this.wayGeometry.getHeader(4));
        return 1;
    }

    protected int setWayGeometryHeader() {
        this.wayGeometry.setHeader(0, this.bitUtil.getIntLow(this.maxGeoRef));
        this.wayGeometry.setHeader(4, this.bitUtil.getIntHigh(this.maxGeoRef));
        return 1;
    }

    void initStorage() {
        this.edgeEntryIndex = 0;
        this.nodeEntryIndex = 0;
        this.edgeAccess.init(this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(this.encodingManager.getBytesForFlags()));
        this.E_GEO = this.nextEdgeEntryIndex(4);
        this.E_NAME = this.nextEdgeEntryIndex(4);
        this.E_ADDITIONAL = this.extStorage.isRequireEdgeField() ? this.nextEdgeEntryIndex(4) : -1;
        this.N_EDGE_REF = this.nextNodeEntryIndex(4);
        this.N_LAT = this.nextNodeEntryIndex(4);
        this.N_LON = this.nextNodeEntryIndex(4);
        this.N_ELE = this.nodeAccess.is3D() ? this.nextNodeEntryIndex(4) : -1;
        this.N_ADDITIONAL = this.extStorage.isRequireNodeField() ? this.nextNodeEntryIndex(4) : -1;
        this.initNodeAndEdgeEntrySize();
        this.listener.initStorage();
        this.initialized = true;
    }

    void initNodeRefs(long oldCapacity, long newCapacity) {
        long pointer;
        for (pointer = oldCapacity + (long)this.N_EDGE_REF; pointer < newCapacity; pointer += (long)this.nodeEntryBytes) {
            this.nodes.setInt(pointer, -1);
        }
        if (this.extStorage.isRequireNodeField()) {
            for (pointer = oldCapacity + (long)this.N_ADDITIONAL; pointer < newCapacity; pointer += (long)this.nodeEntryBytes) {
                this.nodes.setInt(pointer, this.extStorage.getDefaultNodeFieldValue());
            }
        }
    }

    protected final int nextEdgeEntryIndex(int sizeInBytes) {
        int tmp = this.edgeEntryIndex;
        this.edgeEntryIndex += sizeInBytes;
        return tmp;
    }

    protected final int nextNodeEntryIndex(int sizeInBytes) {
        int tmp = this.nodeEntryIndex;
        this.nodeEntryIndex += sizeInBytes;
        return tmp;
    }

    protected final void initNodeAndEdgeEntrySize() {
        this.nodeEntryBytes = this.nodeEntryIndex;
        this.edgeEntryBytes = this.edgeEntryIndex;
    }

    final void ensureNodeIndex(int nodeIndex) {
        if (!this.initialized) {
            throw new AssertionError((Object)"The graph has not yet been initialized.");
        }
        if (nodeIndex < this.nodeCount) {
            return;
        }
        long oldNodes = this.nodeCount;
        this.nodeCount = nodeIndex + 1;
        boolean capacityIncreased = this.nodes.ensureCapacity((long)this.nodeCount * (long)this.nodeEntryBytes);
        if (capacityIncreased) {
            long newBytesCapacity = this.nodes.getCapacity();
            this.initNodeRefs(oldNodes * (long)this.nodeEntryBytes, newBytesCapacity);
        }
    }

    @Override
    public int getNodes() {
        return this.nodeCount;
    }

    @Override
    public int getEdges() {
        return this.getAllEdges().length();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public BBox getBounds() {
        return this.bounds;
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirection) {
        return this.edge(a, b).setDistance(distance).setFlags(this.encodingManager.flagsDefault(true, bothDirection));
    }

    void setSegmentSize(int bytes) {
        this.checkInit();
        this.nodes.setSegmentSize(bytes);
        this.edges.setSegmentSize(bytes);
        this.wayGeometry.setSegmentSize(bytes);
        this.nameIndex.setSegmentSize(bytes);
        this.extStorage.setSegmentSize(bytes);
    }

    synchronized void freeze() {
        if (this.isFrozen()) {
            throw new IllegalStateException("base graph already frozen");
        }
        this.frozen = true;
        this.listener.freeze();
    }

    synchronized boolean isFrozen() {
        return this.frozen;
    }

    public void checkFreeze() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot add edge or node after baseGraph.freeze was called");
        }
    }

    void create(long initSize) {
        this.nodes.create(initSize);
        this.edges.create(initSize);
        initSize = Math.min(initSize, 2000L);
        this.wayGeometry.create(initSize);
        this.nameIndex.create(initSize);
        this.extStorage.create(initSize);
        this.initStorage();
        this.maxGeoRef = 4L;
        this.initNodeRefs(0L, this.nodes.getCapacity());
    }

    String toDetailsString() {
        return "edges:" + Helper.nf((long)this.edgeCount) + "(" + this.edges.getCapacity() / 0x100000L + "MB), nodes:" + Helper.nf((long)this.getNodes()) + "(" + this.nodes.getCapacity() / 0x100000L + "MB), name:(" + this.nameIndex.getCapacity() / 0x100000L + "MB), geo:" + Helper.nf((long)this.maxGeoRef) + "(" + this.wayGeometry.getCapacity() / 0x100000L + "MB), bounds:" + this.bounds;
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodes:");
        String formatNodes = "%12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_EDGE_REF", "N_LAT", "N_LON");
        NodeAccess nodeAccess = this.getNodeAccess();
        for (int i = 0; i < Math.min(this.nodeCount, 100); ++i) {
            System.out.format(Locale.ROOT, formatNodes, i, this.edgeAccess.getEdgeRef(i), nodeAccess.getLat(i), nodeAccess.getLon(i));
        }
        if (this.nodeCount > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes\n", this.nodeCount - 100);
        }
        System.out.println("edges:");
        String formatEdges = "%12s | %12s | %12s | %12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatEdges, "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_DIST", "E_FLAGS");
        IntsRef intsRef = new IntsRef(this.bytesForFlags / 4);
        for (int i = 0; i < Math.min(this.edgeCount, 100); ++i) {
            long edgePointer = this.edgeAccess.toPointer(i);
            this.edgeAccess.readFlags(edgePointer, intsRef);
            System.out.format(Locale.ROOT, formatEdges, i, this.edgeAccess.getNodeA(edgePointer), this.edgeAccess.getNodeB(edgePointer), this.edgeAccess.getLinkA(edgePointer), this.edgeAccess.getLinkB(edgePointer), this.edgeAccess.getDist(edgePointer), intsRef);
        }
        if (this.edgeCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more edges", this.edgeCount - 100);
        }
    }

    void flush() {
        this.setNodesHeader();
        this.setEdgesHeader();
        this.setWayGeometryHeader();
        this.wayGeometry.flush();
        this.nameIndex.flush();
        this.edges.flush();
        this.nodes.flush();
        this.extStorage.flush();
    }

    void close() {
        this.wayGeometry.close();
        this.nameIndex.close();
        this.edges.close();
        this.nodes.close();
        this.extStorage.close();
    }

    long getCapacity() {
        return this.edges.getCapacity() + this.nodes.getCapacity() + this.nameIndex.getCapacity() + this.wayGeometry.getCapacity() + this.extStorage.getCapacity();
    }

    long getMaxGeoRef() {
        return this.maxGeoRef;
    }

    void loadExisting(String dim) {
        if (!this.nodes.loadExisting()) {
            throw new IllegalStateException("Cannot load nodes. corrupt file or directory? " + this.dir);
        }
        if (!dim.equalsIgnoreCase("" + this.nodeAccess.getDimension())) {
            throw new IllegalStateException("Configured dimension (" + this.nodeAccess.getDimension() + ") is not equal to dimension of loaded graph (" + dim + ")");
        }
        if (!this.edges.loadExisting()) {
            throw new IllegalStateException("Cannot load edges. corrupt file or directory? " + this.dir);
        }
        if (!this.wayGeometry.loadExisting()) {
            throw new IllegalStateException("Cannot load geometry. corrupt file or directory? " + this.dir);
        }
        if (!this.nameIndex.loadExisting()) {
            throw new IllegalStateException("Cannot load name index. corrupt file or directory? " + this.dir);
        }
        if (!this.extStorage.loadExisting()) {
            throw new IllegalStateException("Cannot load extended storage. corrupt file or directory? " + this.dir);
        }
        this.initStorage();
        this.loadNodesHeader();
        this.loadEdgesHeader();
        this.loadWayGeometryHeader();
    }

    EdgeIteratorState copyProperties(EdgeIteratorState from, CommonEdgeIterator to) {
        boolean reverse = from.get(EdgeIteratorState.REVERSE_STATE);
        if (to.reverse) {
            reverse = !reverse;
        }
        int nodeA = reverse ? from.getAdjNode() : from.getBaseNode();
        int nodeB = reverse ? from.getBaseNode() : from.getAdjNode();
        long edgePointer = this.edgeAccess.toPointer(to.getEdge());
        int linkA = reverse ? this.edgeAccess.getLinkB(edgePointer) : this.edgeAccess.getLinkA(edgePointer);
        int linkB = reverse ? this.edgeAccess.getLinkA(edgePointer) : this.edgeAccess.getLinkB(edgePointer);
        this.edgeAccess.writeEdge(to.getEdge(), nodeA, nodeB, linkA, linkB);
        this.edgeAccess.writeFlags(edgePointer, from.getFlags());
        to.setDistance(from.getDistance()).setName(from.getName()).setWayGeometry(from.fetchWayGeometry(0));
        if (this.E_ADDITIONAL >= 0) {
            to.setAdditionalField(from.getAdditionalField());
        }
        return to;
    }

    @Override
    public EdgeIteratorState edge(int nodeA, int nodeB) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot create edge if graph is already frozen");
        }
        this.ensureNodeIndex(Math.max(nodeA, nodeB));
        int edgeId = this.edgeAccess.internalEdgeAdd(this.nextEdgeId(), nodeA, nodeB);
        EdgeIterable iter = new EdgeIterable(this, this.edgeAccess, EdgeFilter.ALL_EDGES);
        boolean ret = iter.init(edgeId, nodeB);
        assert (ret);
        if (this.extStorage.isRequireEdgeField()) {
            iter.setAdditionalField(this.extStorage.getDefaultEdgeFieldValue());
        }
        return iter;
    }

    void setEdgeCount(int cnt) {
        this.edgeCount = cnt;
    }

    protected int nextEdgeId() {
        int nextEdge = this.edgeCount++;
        if (this.edgeCount < 0) {
            throw new IllegalStateException("too many edges. new edge id would be negative. " + this.toString());
        }
        this.edges.ensureCapacity(((long)this.edgeCount + 1L) * (long)this.edgeEntryBytes);
        return nextEdge;
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        if (!this.edgeAccess.isInBounds(edgeId)) {
            throw new IllegalStateException("edgeId " + edgeId + " out of bounds");
        }
        this.checkAdjNodeBounds(adjNode);
        return this.edgeAccess.getEdgeProps(edgeId, adjNode);
    }

    final void checkAdjNodeBounds(int adjNode) {
        if (adjNode < 0 && adjNode != Integer.MIN_VALUE || adjNode >= this.nodeCount) {
            throw new IllegalStateException("adjNode " + adjNode + " out of bounds [0," + Helper.nf((long)this.nodeCount) + ")");
        }
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new EdgeIterable(this, this.edgeAccess, filter);
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return new AllEdgeIterator(this, this.edgeAccess);
    }

    @Override
    public Graph copyTo(Graph g) {
        this.initialized = true;
        if (g.getClass().equals(this.getClass())) {
            this._copyTo((BaseGraph)g);
            return g;
        }
        return GHUtility.copyTo(this, g);
    }

    void _copyTo(BaseGraph clonedG) {
        if (clonedG.edgeEntryBytes != this.edgeEntryBytes) {
            throw new IllegalStateException("edgeEntryBytes cannot be different for cloned graph. Cloned: " + clonedG.edgeEntryBytes + " vs " + this.edgeEntryBytes);
        }
        if (clonedG.nodeEntryBytes != this.nodeEntryBytes) {
            throw new IllegalStateException("nodeEntryBytes cannot be different for cloned graph. Cloned: " + clonedG.nodeEntryBytes + " vs " + this.nodeEntryBytes);
        }
        if (clonedG.nodeAccess.getDimension() != this.nodeAccess.getDimension()) {
            throw new IllegalStateException("dimension cannot be different for cloned graph. Cloned: " + clonedG.nodeAccess.getDimension() + " vs " + this.nodeAccess.getDimension());
        }
        this.setNodesHeader();
        this.nodes.copyTo(clonedG.nodes);
        clonedG.loadNodesHeader();
        this.setEdgesHeader();
        this.edges.copyTo(clonedG.edges);
        clonedG.loadEdgesHeader();
        this.nameIndex.copyTo(clonedG.nameIndex);
        this.setWayGeometryHeader();
        this.wayGeometry.copyTo(clonedG.wayGeometry);
        clonedG.loadWayGeometryHeader();
        this.extStorage.copyTo(clonedG.extStorage);
        clonedG.removedNodes = this.removedNodes == null ? null : this.removedNodes.copyTo(new GHBitSetImpl());
    }

    protected void trimToSize() {
        long nodeCap = (long)this.nodeCount * (long)this.nodeEntryBytes;
        this.nodes.trimTo(nodeCap);
    }

    void inPlaceNodeRemove(int removeNodeCount) {
        int oldI;
        int i;
        int toMoveNodes = this.getNodes();
        int itemsToMove = 0;
        SparseIntIntArray oldToNewMap = new SparseIntIntArray(removeNodeCount);
        GHBitSetImpl toRemoveSet = new GHBitSetImpl(removeNodeCount);
        this.removedNodes.copyTo(toRemoveSet);
        if ((double)removeNodeCount > (double)this.getNodes() / 2.0) {
            LoggerFactory.getLogger(this.getClass()).warn("More than a half of the network should be removed!? Nodes:" + this.getNodes() + ", remove:" + removeNodeCount);
        }
        EdgeExplorer delExplorer = this.createEdgeExplorer();
        int removeNode = this.removedNodes.next(0);
        while (removeNode >= 0) {
            EdgeIterator delEdgesIter = delExplorer.setBaseNode(removeNode);
            while (delEdgesIter.next()) {
                toRemoveSet.add(delEdgesIter.getAdjNode());
            }
            --toMoveNodes;
            while (toMoveNodes >= 0 && this.removedNodes.contains(toMoveNodes)) {
                --toMoveNodes;
            }
            if (toMoveNodes >= removeNode) {
                oldToNewMap.put(toMoveNodes, removeNode);
            }
            ++itemsToMove;
            removeNode = this.removedNodes.next(removeNode + 1);
        }
        EdgeIterable adjNodesToDelIter = (EdgeIterable)this.createEdgeExplorer();
        int removeNode2 = toRemoveSet.next(0);
        while (removeNode2 >= 0) {
            adjNodesToDelIter.setBaseNode(removeNode2);
            long prevPointer = -1L;
            while (adjNodesToDelIter.next()) {
                int nodeId = adjNodesToDelIter.getAdjNode();
                if (!EdgeAccess.isInvalidNodeB(nodeId) && this.removedNodes.contains(nodeId)) {
                    int edgeToRemove = adjNodesToDelIter.getEdge();
                    long edgeToRemovePointer = this.edgeAccess.toPointer(edgeToRemove);
                    this.edgeAccess.internalEdgeDisconnect(edgeToRemove, prevPointer, removeNode2);
                    this.edgeAccess.invalidateEdge(edgeToRemovePointer);
                    continue;
                }
                prevPointer = adjNodesToDelIter.edgePointer;
            }
            removeNode2 = toRemoveSet.next(removeNode2 + 1);
        }
        GHBitSetImpl toMoveSet = new GHBitSetImpl(removeNodeCount * 3);
        EdgeExplorer movedEdgeExplorer = this.createEdgeExplorer();
        for (i = 0; i < itemsToMove; ++i) {
            oldI = oldToNewMap.keyAt(i);
            EdgeIterator movedEdgeIter = movedEdgeExplorer.setBaseNode(oldI);
            while (movedEdgeIter.next()) {
                int nodeId = movedEdgeIter.getAdjNode();
                if (EdgeAccess.isInvalidNodeB(nodeId)) continue;
                if (this.removedNodes.contains(nodeId)) {
                    throw new IllegalStateException("shouldn't happen as the edge to the node " + nodeId + " should be already deleted. " + oldI);
                }
                toMoveSet.add(nodeId);
            }
        }
        for (i = 0; i < itemsToMove; ++i) {
            oldI = oldToNewMap.keyAt(i);
            int newI = oldToNewMap.valueAt(i);
            long newOffset = (long)newI * (long)this.nodeEntryBytes;
            long oldOffset = (long)oldI * (long)this.nodeEntryBytes;
            for (long j = 0L; j < (long)this.nodeEntryBytes; j += 4L) {
                this.nodes.setInt(newOffset + j, this.nodes.getInt(oldOffset + j));
            }
        }
        AllEdgesIterator iter = this.getAllEdges();
        while (iter.next()) {
            int updatedB;
            int nodeA = iter.getBaseNode();
            int nodeB = iter.getAdjNode();
            if (!toMoveSet.contains(nodeA) && !toMoveSet.contains(nodeB)) continue;
            int updatedA = oldToNewMap.get(nodeA);
            if (updatedA < 0) {
                updatedA = nodeA;
            }
            if ((updatedB = oldToNewMap.get(nodeB)) < 0) {
                updatedB = nodeB;
            }
            int edgeId = iter.getEdge();
            long edgePointer = this.edgeAccess.toPointer(edgeId);
            int linkA = this.edgeAccess.getLinkA(edgePointer);
            int linkB = this.edgeAccess.getLinkB(edgePointer);
            this.edgeAccess.writeEdge(edgeId, updatedA, updatedB, linkA, linkB);
        }
        if (removeNodeCount >= this.nodeCount) {
            throw new IllegalStateException("graph is empty after in-place removal but was " + removeNodeCount);
        }
        this.initNodeRefs(((long)this.nodeCount - (long)removeNodeCount) * (long)this.nodeEntryBytes, (long)this.nodeCount * (long)this.nodeEntryBytes);
        this.nodeCount -= removeNodeCount;
        if (BaseGraph.isTestingEnabled()) {
            EdgeExplorer explorer = this.createEdgeExplorer();
            iter = this.getAllEdges();
            while (iter.next()) {
                int base = iter.getBaseNode();
                int adj = iter.getAdjNode();
                String str = iter.getEdge() + ", r.contains(" + base + "):" + this.removedNodes.contains(base) + ", r.contains(" + adj + "):" + this.removedNodes.contains(adj) + ", tr.contains(" + base + "):" + toRemoveSet.contains(base) + ", tr.contains(" + adj + "):" + toRemoveSet.contains(adj) + ", base:" + base + ", adj:" + adj + ", nodeCount:" + this.nodeCount;
                if (adj >= this.nodeCount) {
                    throw new RuntimeException("Adj.node problem with edge " + str);
                }
                if (base >= this.nodeCount) {
                    throw new RuntimeException("Base node problem with edge " + str);
                }
                try {
                    explorer.setBaseNode(adj).toString();
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).error("adj:" + adj);
                }
                try {
                    explorer.setBaseNode(base).toString();
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).error("base:" + base);
                }
            }
            explorer.setBaseNode(this.nodeCount - 1).toString();
        }
        this.removedNodes = null;
    }

    @Override
    public GraphExtension getExtension() {
        return this.extStorage;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        long edgePointer = this.edgeAccess.toPointer(edge);
        return this.edgeAccess.getOtherNode(node, edgePointer);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        long edgePointer = this.edgeAccess.toPointer(edge);
        return this.edgeAccess.isAdjacentToNode(node, edgePointer);
    }

    public void setAdditionalEdgeField(long edgePointer, int value) {
        if (!this.extStorage.isRequireEdgeField() || this.E_ADDITIONAL < 0) {
            throw new AssertionError((Object)"This graph does not support an additional edge field.");
        }
        this.edges.setInt(edgePointer + (long)this.E_ADDITIONAL, value);
    }

    private void setWayGeometry_(PointList pillarNodes, long edgePointer, boolean reverse) {
        if (pillarNodes != null && !pillarNodes.isEmpty()) {
            int count;
            if (pillarNodes.getDimension() != this.nodeAccess.getDimension()) {
                throw new IllegalArgumentException("Cannot use pointlist which is " + pillarNodes.getDimension() + "D for graph which is " + this.nodeAccess.getDimension() + "D");
            }
            long existingGeoRef = Helper.toUnsignedLong((int)this.edges.getInt(edgePointer + (long)this.E_GEO));
            int len = pillarNodes.getSize();
            int dim = this.nodeAccess.getDimension();
            if (existingGeoRef > 0L && len <= (count = this.wayGeometry.getInt(existingGeoRef * 4L))) {
                this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, existingGeoRef);
                return;
            }
            long nextGeoRef = this.nextGeoRef(len * dim);
            this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, nextGeoRef);
        } else {
            this.edges.setInt(edgePointer + (long)this.E_GEO, 0);
        }
    }

    private void setWayGeometryAtGeoRef(PointList pillarNodes, long edgePointer, boolean reverse, long geoRef) {
        int len = pillarNodes.getSize();
        int dim = this.nodeAccess.getDimension();
        long geoRefPosition = geoRef * 4L;
        int totalLen = len * dim * 4 + 4;
        this.ensureGeometry(geoRefPosition, totalLen);
        byte[] wayGeometryBytes = this.createWayGeometryBytes(pillarNodes, reverse);
        this.wayGeometry.setBytes(geoRefPosition, wayGeometryBytes, wayGeometryBytes.length);
        this.edges.setInt(edgePointer + (long)this.E_GEO, Helper.toSignedInt((long)geoRef));
    }

    private byte[] createWayGeometryBytes(PointList pillarNodes, boolean reverse) {
        int len = pillarNodes.getSize();
        int dim = this.nodeAccess.getDimension();
        int totalLen = len * dim * 4 + 4;
        byte[] bytes = new byte[totalLen];
        this.bitUtil.fromInt(bytes, len, 0);
        if (reverse) {
            pillarNodes.reverse();
        }
        int tmpOffset = 4;
        boolean is3D = this.nodeAccess.is3D();
        for (int i = 0; i < len; ++i) {
            double lat = pillarNodes.getLatitude(i);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)lat), tmpOffset);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)pillarNodes.getLongitude(i)), tmpOffset += 4);
            tmpOffset += 4;
            if (!is3D) continue;
            this.bitUtil.fromInt(bytes, Helper.eleToInt((double)pillarNodes.getElevation(i)), tmpOffset);
            tmpOffset += 4;
        }
        return bytes;
    }

    private PointList fetchWayGeometry_(long edgePointer, boolean reverse, int mode, int baseNode, int adjNode) {
        long geoRef = Helper.toUnsignedLong((int)this.edges.getInt(edgePointer + (long)this.E_GEO));
        int count = 0;
        byte[] bytes = null;
        if (geoRef > 0L) {
            count = this.wayGeometry.getInt(geoRef *= 4L);
            bytes = new byte[count * this.nodeAccess.getDimension() * 4];
            this.wayGeometry.getBytes(geoRef += 4L, bytes, bytes.length);
        } else if (mode == 0) {
            return PointList.EMPTY;
        }
        PointList pillarNodes = new PointList(count + mode, this.nodeAccess.is3D());
        if (reverse) {
            if ((mode & 2) != 0) {
                pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
            }
        } else if ((mode & 1) != 0) {
            pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
        }
        int index = 0;
        for (int i = 0; i < count; ++i) {
            double lat = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index));
            double lon = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index += 4));
            index += 4;
            if (this.nodeAccess.is3D()) {
                pillarNodes.add(lat, lon, Helper.intToEle((int)this.bitUtil.toInt(bytes, index)));
                index += 4;
                continue;
            }
            pillarNodes.add(lat, lon);
        }
        if (reverse) {
            if ((mode & 1) != 0) {
                pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
            }
            pillarNodes.reverse();
        } else if ((mode & 2) != 0) {
            pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
        }
        return pillarNodes;
    }

    private void setName(long edgePointer, String name) {
        int nameIndexRef = (int)this.nameIndex.put(name);
        if (nameIndexRef < 0) {
            throw new IllegalStateException("Too many names are stored, currently limited to int pointer");
        }
        this.edges.setInt(edgePointer + (long)this.E_NAME, nameIndexRef);
    }

    GHBitSet getRemovedNodes() {
        if (this.removedNodes == null) {
            this.removedNodes = new GHBitSetImpl(this.getNodes());
        }
        return this.removedNodes;
    }

    private void ensureGeometry(long bytePos, int byteLength) {
        this.wayGeometry.ensureCapacity(bytePos + (long)byteLength);
    }

    private long nextGeoRef(int arrayLength) {
        long tmp = this.maxGeoRef;
        this.maxGeoRef += (long)arrayLength + 1L;
        if (this.maxGeoRef >= 0xFFFFFFFFL) {
            throw new IllegalStateException("Geometry too large, does not fit in 32 bits " + this.maxGeoRef);
        }
        return tmp;
    }

    static abstract class CommonEdgeIterator
    implements EdgeIteratorState {
        final BaseGraph baseGraph;
        long edgePointer;
        int baseNode;
        int adjNode;
        EdgeAccess edgeAccess;
        boolean reverse = false;
        boolean freshFlags;
        int edgeId = -1;
        private final IntsRef baseIntsRef;
        int chFlags;

        public CommonEdgeIterator(long edgePointer, EdgeAccess edgeAccess, BaseGraph baseGraph) {
            this.edgePointer = edgePointer;
            this.edgeAccess = edgeAccess;
            this.baseGraph = baseGraph;
            this.baseIntsRef = new IntsRef(baseGraph.bytesForFlags / 4);
        }

        @Override
        public final int getBaseNode() {
            return this.baseNode;
        }

        @Override
        public final int getAdjNode() {
            return this.adjNode;
        }

        @Override
        public final double getDistance() {
            return this.edgeAccess.getDist(this.edgePointer);
        }

        @Override
        public final EdgeIteratorState setDistance(double dist) {
            this.edgeAccess.setDist(this.edgePointer, dist);
            return this;
        }

        @Override
        public IntsRef getFlags() {
            if (!this.freshFlags) {
                this.edgeAccess.readFlags(this.edgePointer, this.baseIntsRef);
                this.freshFlags = true;
            }
            return this.baseIntsRef;
        }

        @Override
        public final EdgeIteratorState setFlags(IntsRef edgeFlags) {
            assert (this.edgeId < this.baseGraph.edgeCount) : "must be edge but was shortcut: " + this.edgeId + " >= " + this.baseGraph.edgeCount + ". Use setFlagsAndWeight";
            this.edgeAccess.writeFlags(this.edgePointer, edgeFlags);
            for (int i = 0; i < edgeFlags.ints.length; ++i) {
                this.baseIntsRef.ints[i] = edgeFlags.ints[i];
            }
            this.freshFlags = true;
            return this;
        }

        @Override
        public final int getAdditionalField() {
            return this.baseGraph.edges.getInt(this.edgePointer + (long)this.baseGraph.E_ADDITIONAL);
        }

        @Override
        public final EdgeIteratorState setAdditionalField(int value) {
            this.baseGraph.setAdditionalEdgeField(this.edgePointer, value);
            return this;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            return property.getBool(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            property.setBool(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            return property.getBool(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            property.setBool(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public int get(IntEncodedValue property) {
            return property.getInt(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            property.setInt(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            return property.getInt(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            property.setInt(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public double get(DecimalEncodedValue property) {
            return property.getDecimal(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            property.setDecimal(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            return property.getDecimal(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            property.setDecimal(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public <T extends Enum> T get(EnumEncodedValue<T> property) {
            return property.getEnum(this.reverse, this.getFlags());
        }

        @Override
        public <T extends Enum> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            property.setEnum(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public <T extends Enum> T getReverse(EnumEncodedValue<T> property) {
            return property.getEnum(!this.reverse, this.getFlags());
        }

        @Override
        public <T extends Enum> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            property.setEnum(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public final EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
            return this.baseGraph.copyProperties(edge, this);
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList pillarNodes) {
            this.baseGraph.setWayGeometry_(pillarNodes, this.edgePointer, this.reverse);
            return this;
        }

        @Override
        public PointList fetchWayGeometry(int mode) {
            return this.baseGraph.fetchWayGeometry_(this.edgePointer, this.reverse, mode, this.getBaseNode(), this.getAdjNode());
        }

        @Override
        public int getEdge() {
            return this.edgeId;
        }

        @Override
        public int getOrigEdgeFirst() {
            return this.getEdge();
        }

        @Override
        public int getOrigEdgeLast() {
            return this.getEdge();
        }

        @Override
        public String getName() {
            int nameIndexRef = this.baseGraph.edges.getInt(this.edgePointer + (long)this.baseGraph.E_NAME);
            return this.baseGraph.nameIndex.get(nameIndexRef);
        }

        @Override
        public EdgeIteratorState setName(String name) {
            this.baseGraph.setName(this.edgePointer, name);
            return this;
        }

        public final String toString() {
            return this.getEdge() + " " + this.getBaseNode() + "-" + this.getAdjNode();
        }
    }

    protected static class AllEdgeIterator
    extends CommonEdgeIterator
    implements AllEdgesIterator {
        public AllEdgeIterator(BaseGraph baseGraph) {
            this(baseGraph, baseGraph.edgeAccess);
        }

        private AllEdgeIterator(BaseGraph baseGraph, EdgeAccess edgeAccess) {
            super(-1L, edgeAccess, baseGraph);
        }

        @Override
        public int length() {
            return this.baseGraph.edgeCount;
        }

        @Override
        public boolean next() {
            do {
                ++this.edgeId;
                this.edgePointer = (long)this.edgeId * (long)this.edgeAccess.getEntryBytes();
                if (!this.checkRange()) {
                    return false;
                }
                this.adjNode = this.edgeAccess.getNodeB(this.edgePointer);
            } while (EdgeAccess.isInvalidNodeB(this.adjNode));
            this.baseNode = this.edgeAccess.getNodeA(this.edgePointer);
            this.freshFlags = false;
            this.reverse = false;
            return true;
        }

        protected boolean checkRange() {
            return this.edgeId < this.baseGraph.edgeCount;
        }

        @Override
        public final EdgeIteratorState detach(boolean reverseArg) {
            if (this.edgePointer < 0L) {
                throw new IllegalStateException("call next before detaching");
            }
            AllEdgeIterator iter = new AllEdgeIterator(this.baseGraph, this.edgeAccess);
            iter.edgeId = this.edgeId;
            iter.edgePointer = this.edgePointer;
            if (reverseArg) {
                iter.reverse = !this.reverse;
                iter.baseNode = this.adjNode;
                iter.adjNode = this.baseNode;
            } else {
                iter.reverse = this.reverse;
                iter.baseNode = this.baseNode;
                iter.adjNode = this.adjNode;
            }
            return iter;
        }
    }

    protected static class EdgeIterable
    extends CommonEdgeIterator
    implements EdgeExplorer,
    EdgeIterator {
        final EdgeFilter filter;
        int nextEdgeId;

        public EdgeIterable(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter filter) {
            super(-1L, edgeAccess, baseGraph);
            if (filter == null) {
                throw new IllegalArgumentException("Instead null filter use EdgeFilter.ALL_EDGES");
            }
            this.filter = filter;
        }

        final void setEdgeId(int edgeId) {
            this.nextEdgeId = this.edgeId = edgeId;
        }

        final boolean init(int tmpEdgeId, int expectedAdjNode) {
            this.setEdgeId(tmpEdgeId);
            if (!EdgeIterator.Edge.isValid(this.edgeId)) {
                throw new IllegalArgumentException("fetching the edge requires a valid edgeId but was " + this.edgeId);
            }
            this.selectEdgeAccess();
            this.edgePointer = this.edgeAccess.toPointer(tmpEdgeId);
            this.baseNode = this.edgeAccess.getNodeA(this.edgePointer);
            this.adjNode = this.edgeAccess.getNodeB(this.edgePointer);
            if (EdgeAccess.isInvalidNodeB(this.adjNode)) {
                throw new IllegalStateException("content of edgeId " + this.edgeId + " is marked as invalid - ie. the edge is already removed!");
            }
            this.nextEdgeId = -1;
            if (expectedAdjNode == this.adjNode || expectedAdjNode == Integer.MIN_VALUE) {
                this.reverse = false;
                return true;
            }
            if (expectedAdjNode == this.baseNode) {
                this.reverse = true;
                this.baseNode = this.adjNode;
                this.adjNode = expectedAdjNode;
                return true;
            }
            return false;
        }

        final void _setBaseNode(int baseNode) {
            this.baseNode = baseNode;
        }

        @Override
        public EdgeIterator setBaseNode(int baseNode) {
            this.setEdgeId(this.baseGraph.edgeAccess.getEdgeRef(baseNode));
            this._setBaseNode(baseNode);
            return this;
        }

        protected void selectEdgeAccess() {
        }

        @Override
        public final boolean next() {
            do {
                if (!EdgeIterator.Edge.isValid(this.nextEdgeId)) {
                    return false;
                }
                this.selectEdgeAccess();
                this.edgePointer = this.edgeAccess.toPointer(this.nextEdgeId);
                this.edgeId = this.nextEdgeId;
                int nodeA = this.edgeAccess.getNodeA(this.edgePointer);
                boolean baseNodeIsNodeA = this.baseNode == nodeA;
                this.adjNode = baseNodeIsNodeA ? this.edgeAccess.getNodeB(this.edgePointer) : nodeA;
                this.reverse = !baseNodeIsNodeA;
                this.freshFlags = false;
                int n = this.nextEdgeId = baseNodeIsNodeA ? this.edgeAccess.getLinkA(this.edgePointer) : this.edgeAccess.getLinkB(this.edgePointer);
                assert (this.nextEdgeId != this.edgeId) : "endless loop detected for base node: " + this.baseNode + ", adj node: " + this.adjNode + ", edge pointer: " + this.edgePointer + ", edge: " + this.edgeId;
            } while (!this.filter.accept(this));
            return true;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            boolean ret;
            if (this.edgeId == this.nextEdgeId || !EdgeIterator.Edge.isValid(this.edgeId)) {
                throw new IllegalStateException("call next before detaching or setEdgeId (edgeId:" + this.edgeId + " vs. next " + this.nextEdgeId + ")");
            }
            EdgeIterable iter = this.edgeAccess.createSingleEdge(this.filter);
            if (reverseArg) {
                ret = iter.init(this.edgeId, this.baseNode);
                iter.reverse = !this.reverse;
            } else {
                ret = iter.init(this.edgeId, this.adjNode);
            }
            assert (ret);
            return iter;
        }
    }
}

