/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import io.quarkus.arc.profile.UnlessBuildProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.Router;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@UnlessBuildProfile(value="test")
public class RouteListener {
    private static final Logger logger = LoggerFactory.getLogger(RouteListener.class);
    private final Router router;
    private final VehicleRepository vehicleRepository;
    private final LocationRepository locationRepository;
    private final Event<RoutingPlan> routingPlanEvent;
    private RoutingPlan bestRoutingPlan;

    @Inject
    RouteListener(Router router, VehicleRepository vehicleRepository, LocationRepository locationRepository, Event<RoutingPlan> routingPlanEvent) {
        this.router = router;
        this.vehicleRepository = vehicleRepository;
        this.locationRepository = locationRepository;
        this.routingPlanEvent = routingPlanEvent;
        this.bestRoutingPlan = RoutingPlan.empty();
    }

    public void onApplicationEvent(@Observes RouteChangedEvent event) {
        Location depot = event.depotId().flatMap(this.locationRepository::find).orElse(null);
        try {
            Map<Long, Vehicle> vehicleMap = event.vehicleIds().stream().collect(Collectors.toMap(vehicleId -> vehicleId, this::findVehicleById));
            Map<Long, Location> visitMap = event.visitIds().stream().collect(Collectors.toMap(visitId -> visitId, this::findLocationById));
            List<RouteWithTrack> routes = event.routes().stream().map(shallowRoute -> new Route((Vehicle)vehicleMap.get(shallowRoute.vehicleId), this.findLocationById(shallowRoute.depotId), shallowRoute.visitIds.stream().map(visitMap::get).collect(Collectors.toList()))).map(route -> new RouteWithTrack((Route)route, this.track(route.depot(), route.visits()))).collect(Collectors.toList());
            this.bestRoutingPlan = new RoutingPlan(event.distance(), new ArrayList<Vehicle>(vehicleMap.values()), depot, new ArrayList<Location>(visitMap.values()), routes);
            this.routingPlanEvent.fire((Object)this.bestRoutingPlan);
        }
        catch (IllegalStateException e) {
            logger.warn("Discarding an outdated routing plan: {}", (Object)e.toString());
        }
    }

    private Vehicle findVehicleById(long id) {
        return this.vehicleRepository.find(id).orElseThrow(() -> new IllegalStateException("Vehicle {id=" + id + "} not found in the repository"));
    }

    private Location findLocationById(long id) {
        return this.locationRepository.find(id).orElseThrow(() -> new IllegalStateException("Location {id=" + id + "} not found in the repository"));
    }

    private List<List<Coordinates>> track(Location depot, List<Location> route) {
        if (route.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> itinerary = new ArrayList<Location>();
        itinerary.add(depot);
        itinerary.addAll(route);
        itinerary.add(depot);
        ArrayList<List<Coordinates>> paths = new ArrayList<List<Coordinates>>();
        for (int i = 0; i < itinerary.size() - 1; ++i) {
            Location fromLocation = (Location)itinerary.get(i);
            Location toLocation = (Location)itinerary.get(i + 1);
            List<Coordinates> path = this.router.getPath(fromLocation.coordinates(), toLocation.coordinates());
            paths.add(path);
        }
        return paths;
    }

    public RoutingPlan getBestRoutingPlan() {
        return this.bestRoutingPlan;
    }
}

