/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionUpdate;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestGenTestWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestGenTestWriter.class);
    private StringBuilder sb;
    private TestGenKieSessionJournal journal;
    private String className;
    private List<String> scoreDrlList = Collections.emptyList();
    private List<File> scoreDrlFileList = Collections.emptyList();
    private ScoreDefinition<?> scoreDefinition;
    private boolean constraintMatchEnabled;
    private TestGenCorruptedScoreException scoreEx;

    TestGenTestWriter() {
    }

    public void print(TestGenKieSessionJournal journal, StringWriter w) {
        this.print(journal);
        w.append(this.sb);
    }

    public void print(TestGenKieSessionJournal journal, File testFile) {
        this.print(journal);
        this.writeTestFile(testFile);
    }

    private void print(TestGenKieSessionJournal journal) {
        this.journal = journal;
        this.sb = new StringBuilder(32768);
        this.printInit();
        this.printSetup();
        this.printTest();
    }

    private void printInit() {
        this.sb.append("package org.optaplanner.testgen;\n\n");
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.junit.jupiter.api.Test");
        imports.add("org.drools.modelcompiler.ExecutableModelProject");
        imports.add("org.kie.api.KieServices");
        imports.add("org.kie.api.builder.KieFileSystem");
        imports.add("org.kie.api.runtime.KieContainer");
        imports.add("org.kie.api.runtime.KieSession");
        if (!this.scoreDrlFileList.isEmpty()) {
            imports.add("java.io.File");
        }
        if (this.scoreDefinition != null) {
            imports.add("org.junit.jupiter.api.Assertions");
            imports.add(ScoreHolder.class.getCanonicalName());
            imports.add(this.scoreDefinition.getClass().getCanonicalName());
        }
        Stream<String> classes = Stream.concat(this.journal.getFacts().stream().flatMap(fact -> fact.getImports().stream()), this.journal.getMoveOperations().stream().filter(op -> op instanceof TestGenKieSessionUpdate).flatMap(up -> ((TestGenKieSessionUpdate)up).getValue().getImports().stream())).filter(cls -> !cls.getPackage().getName().equals("java.lang")).map(cls -> cls.getCanonicalName());
        Stream.concat(imports.stream(), classes).distinct().sorted().forEach(cls -> this.sb.append(String.format("import %s;\n", cls)));
        this.sb.append("\n").append("public class ").append(this.className).append(" {\n\n");
    }

    private void printSetup() {
        this.sb.append("    @Test\n").append("    public void test() {\n").append("        KieServices kieServices = KieServices.Factory.get();\n").append("        KieFileSystem kfs = kieServices.newKieFileSystem();\n");
        this.scoreDrlFileList.forEach(file -> this.sb.append("        kfs.write(kieServices.getResources()\n").append("                .newFileSystemResource(new File(\"").append(file.getAbsoluteFile()).append("\"), \"UTF-8\"));\n"));
        this.scoreDrlList.forEach(drl -> this.sb.append("        kfs.write(kieServices.getResources()\n").append("                .newClassPathResource(\"").append((String)drl).append("\"));\n"));
        this.sb.append("        kieServices.newKieBuilder(kfs).buildAll(ExecutableModelProject.class);\n").append("        KieContainer kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());\n").append("        KieSession kieSession = kieContainer.newKieSession();\n\n");
        if (this.scoreDefinition != null) {
            this.sb.append("        ScoreHolder scoreHolder = new ").append(this.scoreDefinition.getClass().getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append(");\n");
            this.sb.append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);\n\n");
        }
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printInitialization(this.sb);
        }
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printSetup(this.sb);
        }
        this.sb.append("\n");
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
            testGenKieSessionOperation.print(this.sb);
        }
        this.sb.append("\n");
    }

    private void printTest() {
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getMoveOperations()) {
            testGenKieSessionOperation.print(this.sb);
        }
        if (this.scoreEx != null) {
            this.sb.append("        // This is the corrupted score, just to make sure the bug is reproducible\n").append("        Assertions.assertEquals(\"").append(this.scoreEx.getWorkingScore()).append("\", scoreHolder.extractScore(0).toString());\n");
            this.sb.append("        kieSession = kieContainer.newKieSession();\n").append("        scoreHolder = new ").append(this.scoreDefinition.getClass().getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append(");\n").append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);\n");
            this.sb.append("\n        // Insert everything into a fresh session to see the uncorrupted score\n");
            for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
                testGenKieSessionOperation.print(this.sb);
            }
            this.sb.append("        kieSession.fireAllRules();\n").append("        Assertions.assertEquals(\"").append(this.scoreEx.getUncorruptedScore()).append("\", scoreHolder.extractScore(0).toString());\n");
        }
        this.sb.append("    }\n").append("}\n");
    }

    private void writeTestFile(File file) {
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            LOGGER.warn("Couldn't create directory: {}", (Object)parent);
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8.name());){
            osw.append(this.sb);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to open test file ({}).", (Object)file, (Object)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Failed to open writer.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write test file ({}).", (Object)file, (Object)e);
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList == null ? Collections.emptyList() : scoreDrlList;
    }

    public void setScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList == null ? Collections.emptyList() : scoreDrlFileList;
    }

    public void setScoreDefinition(ScoreDefinition<?> scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public void setConstraintMatchEnabled(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
    }

    public void setCorruptedScoreException(TestGenCorruptedScoreException ex) {
        this.scoreEx = ex;
    }
}

