/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devconsole;

import io.quarkus.arc.InjectableBean;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Invocation {
    private final InjectableBean<?> interceptedBean;
    private final long start;
    private final long duration;
    private final Method method;
    private final Kind kind;
    private final String message;
    private final List<Invocation> children;

    Invocation(InjectableBean<?> interceptedBean, long start, long duration, Method method, Kind kind, String message, List<Invocation> children) {
        this.interceptedBean = interceptedBean;
        this.start = start;
        this.duration = duration;
        this.method = method;
        this.children = children;
        this.kind = kind;
        this.message = message;
    }

    public InjectableBean<?> getInterceptedBean() {
        return this.interceptedBean;
    }

    public long getStart() {
        return this.start;
    }

    public String getStartFormatted() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.start), ZoneId.systemDefault()).toString();
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDurationMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.duration);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getDeclaringClassName() {
        return this.method.getDeclaringClass().getName();
    }

    public List<Invocation> getChildren() {
        return this.children;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return (Object)((Object)this.kind) + " invocation of " + this.method;
    }

    public String getPackageName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(0, lastDot);
        }
        return "";
    }

    static class Builder {
        private InjectableBean<?> interceptedBean;
        private long start;
        private long duration;
        private Method method;
        private List<Builder> children;
        private Builder parent;
        private Kind kind;
        private String message;

        Builder() {
        }

        Builder newChild() {
            Builder child = new Builder();
            this.addChild(child);
            return child;
        }

        Builder setInterceptedBean(InjectableBean<?> bean) {
            this.interceptedBean = bean;
            return this;
        }

        Builder setStart(long start) {
            this.start = start;
            return this;
        }

        Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        Builder setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        Builder getParent() {
            return this.parent;
        }

        Builder setParent(Builder parent) {
            this.parent = parent;
            return this;
        }

        Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        boolean addChild(Builder child) {
            if (this.children == null) {
                this.children = new ArrayList<Builder>();
            }
            child.setParent(this);
            return this.children.add(child);
        }

        Invocation build() {
            ArrayList<Invocation> invocations = null;
            if (this.children != null) {
                invocations = new ArrayList<Invocation>(this.children.size());
                for (Builder builder : this.children) {
                    invocations.add(builder.build());
                }
            }
            return new Invocation(this.interceptedBean, this.start, this.duration, this.method, this.kind, this.message, invocations);
        }
    }

    public static enum Kind {
        BUSINESS,
        PRODUCER,
        DISPOSER,
        OBSERVER;

    }
}

