/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.dtgov.services.deploy.Deployer;
import org.overlord.dtgov.services.deploy.DeployerProvider;

public class DeployerFactory {
    private static Map<String, Deployer> deployers = new HashMap<String, Deployer>();

    private static void loadDeployers() {
        File directory;
        Set providers = ServiceRegistryUtil.getServices(DeployerProvider.class);
        for (DeployerProvider provider : providers) {
            Map<String, Deployer> deployers_provider = provider.createDeployers();
            if (deployers_provider == null || deployers_provider.isEmpty()) continue;
            deployers.putAll(deployers_provider);
        }
        LinkedList<URLClassLoader> loaders = new LinkedList<URLClassLoader>();
        String customDeployerDirPath = System.getProperty("dtgov.deployers.customDir");
        if (customDeployerDirPath != null && customDeployerDirPath.trim().length() > 0 && (directory = new File(customDeployerDirPath)).isDirectory()) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{"jar"}, (boolean)false);
            for (File jarFile : jarFiles) {
                try {
                    URL jarUrl = jarFile.toURI().toURL();
                    arrayList.add(jarUrl);
                }
                catch (MalformedURLException e) {}
            }
            URL[] urls = arrayList.toArray(new URL[arrayList.size()]);
            URLClassLoader jarCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            loaders.add(jarCL);
        }
        for (ClassLoader classLoader : loaders) {
            for (DeployerProvider provider : ServiceLoader.load(DeployerProvider.class, classLoader)) {
                Map<String, Deployer> deployers_provider = provider.createDeployers();
                if (deployers_provider == null || deployers_provider.isEmpty()) continue;
                deployers.putAll(deployers_provider);
            }
        }
    }

    public static final Deployer createDeployer(String deployerType) {
        Deployer deployer = deployers.get(deployerType);
        return deployer;
    }

    static {
        DeployerFactory.loadDeployers();
    }
}

