/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy.deployers;

import java.util.Map;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.services.deploy.Deployer;
import org.overlord.dtgov.services.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.common.SrampModelUtils;

public abstract class AbstractDeployer
implements Deployer {
    protected void recordUndeploymentInfo(BaseArtifactType artifact, Target target, Map<String, String> props, SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        ExtendedArtifactType undeploymentArtifact = new ExtendedArtifactType();
        undeploymentArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        undeploymentArtifact.setExtendedType("UndeploymentInformation");
        undeploymentArtifact.setName(artifact.getName() + ".undeploy");
        undeploymentArtifact.setDescription(Messages.i18n.format("DeploymentResource.UndeploymentInfoDescription", new Object[]{artifact.getName()}));
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.target", (String)target.getName());
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.type", (String)target.getType().name());
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.classifier", (String)target.getClassifier());
        if (props != null) {
            for (String propKey : props.keySet()) {
                String propVal = props.get(propKey);
                SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)propKey, (String)propVal);
            }
        }
        SrampModelUtils.addGenericRelationship((BaseArtifactType)undeploymentArtifact, (String)"describesDeployment", (String)artifact.getUuid());
        client.createArtifact((BaseArtifactType)undeploymentArtifact);
    }
}

